/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.veroxuniverse.samurai_dynasty.entity.ModEntityTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KawausoEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VISION = SynchedEntityData.m_135353_(KawausoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int visionTimer;
    private final int coolDownTimeVision = 6000;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public KawausoEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7105_(false);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42589_}), true));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, (double)1.2f, 8.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, (double)1.2f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VISION, (Object)6000);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(VISION, (Object)pCompound.m_128451_("HealCooldown"));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("HealCooldown", this.getVisionCooldown());
    }

    public void setVisionCooldown(int healing) {
        this.f_19804_.m_135381_(VISION, (Object)healing);
    }

    public int getVisionCooldown() {
        return (Integer)this.f_19804_.m_135370_(VISION);
    }

    public void m_8119_() {
        if (this.getVisionCooldown() > 6001) {
            this.setVisionCooldown(6001);
        }
        if (this.getVisionCooldown() <= 6000) {
            this.visionTimer = this.getVisionCooldown();
            ++this.visionTimer;
            this.setVisionCooldown(this.visionTimer);
        }
        if (this.getVisionCooldown() == 6000) {
            Player pOwner = (Player)this.m_269323_();
            if (this.m_269323_() != null) {
                this.m_5496_(SoundEvents.f_11887_, 100.0f, 2.0f);
                if (pOwner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)pOwner;
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7a\u00a7lNight Vision\u00a77 is ready!"), true);
                }
            }
        }
        super.m_8119_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        Item itemForTaming;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (item == (itemForTaming = Items.f_42589_) && !this.m_21824_()) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.CONSUME;
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                super.m_21828_(pPlayer);
                this.f_21344_.m_26569_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_21839_(true);
                this.m_21837_(true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && pHand == InteractionHand.MAIN_HAND && !pPlayer.m_6144_() && !this.m_6898_(itemstack)) {
            this.m_21839_(!this.m_21827_());
            this.m_21837_(!this.m_21827_());
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && pHand == InteractionHand.MAIN_HAND && pPlayer.m_6144_() && !this.m_6898_(itemstack)) {
            if (this.getVisionCooldown() >= 6000) {
                this.setVisionCooldown(0);
                this.visionTimer = 0;
                pPlayer.m_5496_(SoundEvents.f_144048_, 100.0f, 1.0f);
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)pPlayer;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 3600, 0, false, false, false));
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7e300 \u00a77seconds left!"), true);
                }
            } else {
                pPlayer.m_5496_(SoundEvents.f_12507_, 100.0f, 1.6f);
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)pPlayer;
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7e" + (6000 - this.visionTimer) / 20 + " \u00a77seconds left!")), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "move_controller", 5, state -> {
            if (state.isMoving()) {
                state.setAnimation(RawAnimation.begin().then("animation.kawauso.walk", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            if (!state.isMoving() && !this.m_21825_()) {
                state.setAnimation(RawAnimation.begin().then("animation.kawauso.idle", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (this.f_20911_) {
                state.setAnimation(RawAnimation.begin().then("animation.kawauso.attack", Animation.LoopType.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "kawauso_sit_controller", 5, state -> {
            if (this.m_21825_() && this.m_21824_()) {
                state.setAnimation(RawAnimation.begin().then("animation.kawauso.sit", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_42405_);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_243764_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_243972_;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntityTypes.KAWAUSO.get()).m_20615_((Level)pLevel);
    }
}

