/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.corelib.item.ItemUtils;
import de.maxhenkel.camera.corelib.net.NetUtils;
import de.maxhenkel.camera.gui.CameraScreen;
import de.maxhenkel.camera.net.MessageTakeImage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CameraItem
extends Item {
    public CameraItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_() && !this.isActive(stack)) {
            if (worldIn.f_46443_) {
                this.openClientGui(this.getShader(stack));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!(playerIn instanceof ServerPlayer)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!this.isActive(stack)) {
            ((CameraItem)((Object)Main.CAMERA.get())).setActive(stack, true);
        } else if (Main.PACKET_MANAGER.canTakeImage(playerIn.m_20148_())) {
            if (CameraItem.consumePaper(playerIn)) {
                worldIn.m_5594_(null, playerIn.m_20183_(), (SoundEvent)ModSounds.TAKE_IMAGE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                UUID uuid = UUID.randomUUID();
                NetUtils.sendTo(Main.SIMPLE_CHANNEL, (ServerPlayer)playerIn, new MessageTakeImage(uuid));
                ((CameraItem)((Object)Main.CAMERA.get())).setActive(stack, false);
            } else {
                playerIn.m_5661_((Component)Component.m_237115_((String)"message.no_consumable"), true);
            }
        } else {
            playerIn.m_5661_((Component)Component.m_237115_((String)"message.image_cooldown"), true);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(String currentShader) {
        Minecraft.m_91087_().m_91152_((Screen)new CameraScreen(currentShader));
    }

    public int m_8105_(ItemStack stack) {
        return 50000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.isActive(stack)) {
            return UseAnim.BOW;
        }
        return UseAnim.NONE;
    }

    public static boolean consumePaper(Player player) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        int amountNeeded = (Integer)Main.SERVER_CONFIG.cameraConsumeItemAmount.get();
        List<ItemStack> consumeStacks = CameraItem.findPaper(player);
        int count = 0;
        for (ItemStack stack : consumeStacks) {
            count += stack.m_41613_();
        }
        if (count >= amountNeeded) {
            for (ItemStack stack : consumeStacks) {
                amountNeeded -= stack.m_41613_() - ItemUtils.itemStackAmount(-amountNeeded, stack, null).m_41613_();
            }
            return true;
        }
        return false;
    }

    private static List<ItemStack> findPaper(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (CameraItem.isPaper(player.m_21120_(InteractionHand.MAIN_HAND))) {
            items.add(player.m_21120_(InteractionHand.MAIN_HAND));
        }
        if (CameraItem.isPaper(player.m_21120_(InteractionHand.OFF_HAND))) {
            items.add(player.m_21120_(InteractionHand.OFF_HAND));
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!CameraItem.isPaper(itemstack)) continue;
            items.add(itemstack);
        }
        return items;
    }

    protected static boolean isPaper(ItemStack stack) {
        return stack.m_204117_(Main.IMAGE_PAPER);
    }

    public boolean isActive(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128441_("active")) {
            compound.m_128379_("active", false);
        }
        return compound.m_128471_("active");
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("active", active);
    }

    public String getShader(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128441_("shader")) {
            return null;
        }
        return compound.m_128461_("shader");
    }

    public void setShader(ItemStack stack, String shader) {
        if (shader != null) {
            stack.m_41784_().m_128359_("shader", shader);
        }
    }
}

