/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities.horde;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.entities.HordeGraveyardEntity;
import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.init.TGEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public class GraveyardHordeSpawner
implements CustomSpawner {
    private int ticksUntilNextSpawn;

    public int m_7995_(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        if (!spawnMonsters) {
            return 0;
        }
        if (!Graveyard.getConfig().getHorde((ResourceLocation)new ResourceLocation((String)"graveyard", (String)"horde_spawn")).enabled) {
            return 0;
        }
        RandomSource random = world.f_46441_;
        --this.ticksUntilNextSpawn;
        if (this.ticksUntilNextSpawn > 0) {
            return 0;
        }
        int randomizer = Graveyard.getConfig().getHorde((ResourceLocation)new ResourceLocation((String)"graveyard", (String)"horde_spawn")).additionalRandomizedTicks;
        this.ticksUntilNextSpawn += Graveyard.getConfig().getHorde((ResourceLocation)new ResourceLocation((String)"graveyard", (String)"horde_spawn")).ticksUntilNextSpawn + random.m_188503_(randomizer <= 0 ? 1200 : randomizer);
        if (world.m_46462_()) {
            if (random.m_188503_(5) != 0) {
                return 0;
            }
            int i = world.m_6907_().size();
            if (i < 1) {
                return 0;
            }
            Player playerEntity = (Player)world.m_6907_().get(random.m_188503_(i));
            if (playerEntity.m_5833_()) {
                return 0;
            }
            if (world.m_8736_(playerEntity.m_20183_(), 2)) {
                return 0;
            }
            int j = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            int k = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos mutable = playerEntity.m_20183_().m_122032_().m_122184_(j, 0, k);
            if (!world.m_151572_(mutable.m_123341_() - 10, mutable.m_123343_() - 10, mutable.m_123341_() + 10, mutable.m_123343_() + 10)) {
                return 0;
            }
            Holder registryEntry = world.m_204166_((BlockPos)mutable);
            if (registryEntry.m_203656_(BiomeTags.f_215806_)) {
                return 0;
            }
            int n = 0;
            int o = Graveyard.getConfig().getHorde((ResourceLocation)new ResourceLocation((String)"graveyard", (String)"horde_spawn")).mobSpawnAttempts;
            boolean illagerSpawn = random.m_188499_();
            for (int p = 0; p < o; ++p) {
                ++n;
                mutable.m_142448_(world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).m_123342_());
                if (p == 0) {
                    if (!this.spawnHordeEntity(world, (BlockPos)mutable, random, true, illagerSpawn)) {
                        break;
                    }
                } else {
                    this.spawnHordeEntity(world, (BlockPos)mutable, random, false, illagerSpawn);
                }
                mutable.m_142451_(mutable.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
                mutable.m_142443_(mutable.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
            }
            return n;
        }
        return 0;
    }

    private boolean spawnHordeEntity(ServerLevel world, BlockPos pos, RandomSource random, boolean captain, boolean illagerSpawn) {
        HordeGraveyardEntity hordeEntity;
        BlockState blockState = world.m_8055_(pos);
        BlockState downState = world.m_8055_(pos.m_7495_());
        if (!NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.m_60819_(), TGEntities.GHOUL.get()) || !NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.m_60819_(), TGEntities.REVENANT.get())) {
            return false;
        }
        if (world.m_46803_(pos) > 1) {
            return false;
        }
        if (blockState.m_60819_().m_205070_(FluidTags.f_13131_) || downState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        if (!HostileGraveyardEntity.canSpawnInDarkness(TGEntities.GHOUL.get(), (ServerLevelAccessor)world, MobSpawnType.PATROL, pos, random)) {
            return false;
        }
        if (!illagerSpawn) {
            hordeEntity = random.m_188499_() ? (HordeGraveyardEntity)TGEntities.GHOUL.get().m_20615_((Level)world) : (HordeGraveyardEntity)TGEntities.REVENANT.get().m_20615_((Level)world);
        } else {
            int rand = random.m_188503_(5);
            switch (rand) {
                case 0: 
                case 1: {
                    hordeEntity = (HordeGraveyardEntity)TGEntities.CORRUPTED_PILLAGER.get().m_20615_((Level)world);
                    break;
                }
                case 2: 
                case 3: {
                    hordeEntity = (HordeGraveyardEntity)TGEntities.CORRUPTED_VINDICATOR.get().m_20615_((Level)world);
                    break;
                }
                default: {
                    hordeEntity = (HordeGraveyardEntity)TGEntities.ACOLYTE.get().m_20615_((Level)world);
                }
            }
        }
        if (hordeEntity != null) {
            if (captain) {
                hordeEntity.setPatrolLeader(true);
                hordeEntity.setRandomPatrolTarget();
                world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("A large Graveyard horde of undead appeared at " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + ".")), false);
            }
            hordeEntity.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            hordeEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.PATROL, null, null);
            hordeEntity.m_21573_().m_26573_();
            world.m_47205_((Entity)hordeEntity);
            return true;
        }
        return false;
    }
}

