/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.Graveyard;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class HostileGraveyardEntity
extends Monster {
    private String name;
    private static final EntityDataAccessor<Boolean> CAN_BURN_IN_SUNLIGHT = SynchedEntityData.m_135353_(HostileGraveyardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HostileGraveyardEntity(EntityType<? extends Monster> entityType, Level world, String name) {
        super(entityType, world);
        this.name = name;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CAN_BURN_IN_SUNLIGHT, (Object)true);
        super.m_8097_();
    }

    protected boolean m_21527_() {
        return super.m_21527_();
    }

    protected boolean burnsInDaylight() {
        return true;
    }

    private boolean canBurnInSunlight() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BURN_IN_SUNLIGHT);
    }

    public void setCanBurnInSunlight(boolean bool) {
        this.f_19804_.m_135381_(CAN_BURN_IN_SUNLIGHT, (Object)bool);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128379_("canBurn", this.canBurnInSunlight());
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        if (!nbt.m_128441_("canBurn")) {
            this.setCanBurnInSunlight(this.canBurnInSunlight());
        } else {
            this.setCanBurnInSunlight(nbt.m_128471_("canBurn"));
        }
        super.m_7378_(nbt);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (effect.m_19544_() == MobEffects.f_19615_) {
            return Graveyard.getConfig().mobConfigEntries.get((Object)this.name).canBeWithered;
        }
        return super.m_7301_(effect);
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            boolean bl;
            boolean bl2 = bl = this.burnsInDaylight() && this.m_21527_() && Graveyard.getConfig().mobConfigEntries.get((Object)this.name).canBurnInSunlight && this.canBurnInSunlight();
            if (bl) {
                ItemStack itemStack = this.m_6844_(EquipmentSlot.HEAD);
                if (!itemStack.m_41619_()) {
                    if (itemStack.m_41763_()) {
                        itemStack.m_41721_(itemStack.m_41773_() + this.f_19796_.m_188503_(2));
                        if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                            this.m_21166_(EquipmentSlot.HEAD);
                            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    this.m_20254_(8);
                }
            }
        }
        super.m_8107_();
    }

    public static boolean canSpawnInDarkness(EntityType<? extends Monster> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (world.m_204166_(pos).m_203656_(BiomeTags.f_215806_)) {
            return false;
        }
        return Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean canSpawnInLight(EntityType<? extends Monster> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return Monster.m_219019_(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }
}

