/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.StringUtils;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.util.CommonProxy;

public enum PlayerHeadProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity tile = (SkullBlockEntity)blockEntity;
            GameProfile profile = tile.m_59779_();
            if (profile == null) {
                return;
            }
            String name = profile.getName();
            if (name == null) {
                name = CommonProxy.getLastKnownUsername(profile.getId());
            }
            if (name == null || StringUtils.isBlank((CharSequence)name)) {
                return;
            }
            if (!name.contains(" ") && !name.contains("\u00a7")) {
                name = I18n.m_118938_((String)(Items.f_42680_.m_5524_() + ".named"), (Object[])new Object[]{name});
            }
            tooltip.remove(Identifiers.CORE_OBJECT_NAME);
            tooltip.add(0, (Component)IThemeHelper.get().title(name), Identifiers.CORE_OBJECT_NAME);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_PLAYER_HEAD;
    }
}

