/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk;

import com.mojang.serialization.Codec;
import io.github.mortuusars.chalk.advancement.ChalkDrawTrigger;
import io.github.mortuusars.chalk.advancement.ConsecutiveSleepingTrigger;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.items.ChalkBoxItem;
import io.github.mortuusars.chalk.items.ChalkItem;
import io.github.mortuusars.chalk.loot.LootTableAdditionModifier;
import io.github.mortuusars.chalk.menus.ChalkBoxMenu;
import io.github.mortuusars.chalk.render.ChalkColors;
import java.util.HashMap;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chalk")
public class Chalk {
    public static final String ID = "chalk";
    public static final Logger LOGGER = LogManager.getLogger();

    public Chalk() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Blocks.BLOCKS.register(modEventBus);
        Items.ITEMS.register(modEventBus);
        Menus.MENUS.register(modEventBus);
        LootModifiers.LOOT_MODIFIERS.register(modEventBus);
        SoundEvents.SOUND_EVENTS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static class Blocks {
        private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chalk");
        public static final HashMap<DyeColor, RegistryObject<ChalkMarkBlock>> MARKS = new HashMap();

        public static ChalkMarkBlock getMarkBlock(DyeColor color) {
            return (ChalkMarkBlock)((Object)MARKS.get(color).get());
        }

        static {
            for (DyeColor color : ChalkColors.COLORS.keySet()) {
                MARKS.put(color, (RegistryObject<ChalkMarkBlock>)BLOCKS.register(color + "_chalk_mark", () -> new ChalkMarkBlock(color, BlockBehaviour.Properties.m_284310_().m_284268_(color).m_278166_(PushReaction.DESTROY).m_60966_().m_60955_().m_60910_().m_60991_((state, level, pos) -> (Boolean)state.m_61143_((Property)ChalkMarkBlock.GLOWING)).m_60918_(SoundType.f_56739_))));
            }
        }
    }

    public static class Items {
        private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"chalk");
        public static HashMap<DyeColor, RegistryObject<ChalkItem>> CHALKS = new HashMap();
        public static final RegistryObject<ChalkBoxItem> CHALK_BOX = ITEMS.register("chalk_box", () -> new ChalkBoxItem(new Item.Properties().m_41487_(1)));

        public static ChalkItem getChalk(DyeColor color) {
            return (ChalkItem)CHALKS.get(color).get();
        }

        static {
            for (DyeColor color : ChalkColors.COLORS.keySet()) {
                CHALKS.put(color, (RegistryObject<ChalkItem>)ITEMS.register(color + "_chalk", () -> new ChalkItem(color, new Item.Properties())));
            }
        }
    }

    public static class Menus {
        private static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"chalk");
        public static final RegistryObject<MenuType<ChalkBoxMenu>> CHALK_BOX = MENUS.register("chalk_box", () -> IForgeMenuType.create(ChalkBoxMenu::fromBuffer));
    }

    public static class LootModifiers {
        private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"chalk");
        public static final RegistryObject<Codec<LootTableAdditionModifier>> LOOT_TABLE_ADDITION = LOOT_MODIFIERS.register("loot_table_addition", LootTableAdditionModifier.CODEC);
    }

    public static class SoundEvents {
        private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"chalk");
        public static final RegistryObject<SoundEvent> CHALK_BOX_CHANGE = SOUND_EVENTS.register("item.chalk_box_change", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("item.chalk_box_change")));
        public static final RegistryObject<SoundEvent> CHALK_BOX_OPEN = SOUND_EVENTS.register("item.chalk_box_open", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("item.chalk_box_open")));
        public static final RegistryObject<SoundEvent> CHALK_BOX_CLOSE = SOUND_EVENTS.register("item.chalk_box_close", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("item.chalk_box_close")));
        public static final RegistryObject<SoundEvent> MARK_DRAW = SOUND_EVENTS.register("item.chalk_draw", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("item.chalk_draw")));
        public static final RegistryObject<SoundEvent> GLOW_APPLIED = SOUND_EVENTS.register("item.glow_applied", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("item.glow_applied")));
        public static final RegistryObject<SoundEvent> GLOWING = SOUND_EVENTS.register("ambient.glowing", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("ambient.glowing")));
        public static final RegistryObject<SoundEvent> MARK_REMOVED = SOUND_EVENTS.register("block.mark_removed", () -> SoundEvent.m_262824_((ResourceLocation)Chalk.resource("block.mark_removed")));
    }

    public static class CriteriaTriggers {
        public static final ConsecutiveSleepingTrigger CONSECUTIVE_SLEEPING = new ConsecutiveSleepingTrigger();
        public static final ChalkDrawTrigger CHALK_DRAW_COLORS = new ChalkDrawTrigger();

        public static void register() {
            net.minecraft.advancements.CriteriaTriggers.m_10595_((CriterionTrigger)CONSECUTIVE_SLEEPING);
            net.minecraft.advancements.CriteriaTriggers.m_10595_((CriterionTrigger)CHALK_DRAW_COLORS);
        }
    }

    public static class Tags {

        public static final class Blocks {
            public static final TagKey<Block> CHALK_MARKS = BlockTags.create((ResourceLocation)new ResourceLocation("chalk:chalk_marks"));
            public static final TagKey<Block> CHALK_CANNOT_DRAW_ON = BlockTags.create((ResourceLocation)new ResourceLocation("chalk:chalk_cannot_draw_on"));
        }

        public static final class Items {
            public static final TagKey<Item> CHALKS = ItemTags.create((ResourceLocation)new ResourceLocation("chalk:chalks"));
            public static final TagKey<Item> FORGE_CHALKS = ItemTags.create((ResourceLocation)new ResourceLocation("forge:chalks"));
            public static final TagKey<Item> GLOWINGS = ItemTags.create((ResourceLocation)new ResourceLocation("chalk:glowings"));
        }
    }
}

