/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.util;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.AbstractMovingBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.MovingMetalBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MagneticEntityAccessor;
import com.github.alexmodguy.alexscaves.server.message.PlayerJumpFromMagnetMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagnetUtil {
    private static Stream<BlockPos> getNearbyAttractingMagnets(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.ATTRACTING_MAGNETS.getKey()), (Predicate)Predicates.alwaysTrue(), blockpos, range, PoiManager.Occupancy.ANY);
    }

    private static Stream<BlockPos> getNearbyRepellingMagnets(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.REPELLING_MAGNETS.getKey()), (Predicate)Predicates.alwaysTrue(), blockpos, range, PoiManager.Occupancy.ANY);
    }

    public static void tickMagnetism(Entity entity) {
        Level level;
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int range = 5;
            Stream<BlockPos> attracts = MagnetUtil.getNearbyAttractingMagnets(entity.m_20183_(), serverLevel, range);
            Stream<BlockPos> repels = MagnetUtil.getNearbyRepellingMagnets(entity.m_20183_(), serverLevel, range);
            attracts.forEach(magnet -> {
                Vec3 center = Vec3.m_82512_((Vec3i)magnet);
                double distance = Mth.m_14008_((double)(Math.sqrt(entity.m_20238_(center)) / (double)range), (double)0.0, (double)1.0);
                Vec3 pull = Vec3.m_82512_((Vec3i)magnet).m_82546_(entity.m_20182_());
                Vec3 pullNorm = pull.m_82553_() < 1.0 ? pull : pull.m_82541_();
                Vec3 pullScale = pullNorm.m_82490_((1.0 - distance) * 0.25);
                MagnetUtil.setEntityMagneticDelta(entity, MagnetUtil.getEntityMagneticDelta(entity).m_82490_(0.9).m_82549_(pullScale));
            });
            repels.forEach(magnet -> {
                Vec3 center = Vec3.m_82512_((Vec3i)magnet);
                double distance = Mth.m_14008_((double)(Math.sqrt(entity.m_20238_(center)) / (double)range), (double)0.0, (double)1.0);
                Vec3 pull = entity.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)magnet));
                Vec3 pullNorm = pull.m_82553_() < 1.0 ? pull : pull.m_82541_();
                Vec3 pullScale = pullNorm.m_82490_((1.0 - distance) * 0.25);
                MagnetUtil.setEntityMagneticDelta(entity, MagnetUtil.getEntityMagneticDelta(entity).m_82490_(0.9).m_82549_(pullScale));
            });
        }
        Vec3 vec3 = MagnetUtil.getEntityMagneticDelta(entity);
        Direction dir = MagnetUtil.getEntityMagneticDirection(entity);
        MagneticEntityAccessor magneticAccessor = (MagneticEntityAccessor)entity;
        boolean attatchesToMagnets = (Boolean)AlexsCaves.COMMON_CONFIG.walkingOnMagnets.get() != false && MagnetUtil.attachesToMagnets(entity);
        float progress = magneticAccessor.getAttachmentProgress(1.0f);
        if (vec3 != Vec3.f_82478_) {
            Direction standingOnDirection = MagnetUtil.getStandingOnMagnetSurface(entity);
            float overrideByWalking = 1.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living.f_20899_ && standingOnDirection == dir) {
                    if (living.m_9236_().f_46443_) {
                        AlexsCaves.sendMSGToServer(new PlayerJumpFromMagnetMessage(living.m_19879_(), living.f_20899_));
                    }
                    magneticAccessor.postMagnetJump();
                }
                float detract = living.f_20900_ * living.f_20900_ + living.f_20901_ * living.f_20901_ + living.f_20902_ * living.f_20902_;
                overrideByWalking = (float)((double)overrideByWalking - Math.min(1.0, Math.sqrt(detract) * (double)0.7f));
            }
            if (!MagnetUtil.isEntityOnMovingMetal(entity)) {
                if (attatchesToMagnets) {
                    if (dir == Direction.DOWN && standingOnDirection == null) {
                        vec31 = vec3.m_82542_((double)overrideByWalking, (double)overrideByWalking, (double)overrideByWalking);
                        entity.m_20256_(entity.m_20184_().m_82549_(vec31));
                        entity.m_6210_();
                    } else {
                        magneticAccessor.stepOnMagnetBlock(MagnetUtil.getSamplePosForDirection(entity, dir, 0.5f));
                        float f1 = Math.abs(dir.m_122429_());
                        float f2 = Math.abs(dir.m_122430_());
                        float f3 = Math.abs(dir.m_122431_());
                        vec31 = vec3.m_82542_((double)(overrideByWalking * f1), (double)(overrideByWalking * f2), (double)(overrideByWalking * f3));
                        if (entity.m_20089_() == Pose.SWIMMING) {
                            entity.m_20124_(Pose.STANDING);
                        }
                        if (entity instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity;
                            vec31 = MagnetUtil.processMovementControls(0.0f, living, dir);
                        }
                        entity.m_20256_(vec31);
                    }
                    Direction closest = MagnetUtil.calculateClosestDirection(entity);
                    if (closest != null && closest != Direction.DOWN) {
                        entity.f_19789_ = 0.0f;
                    }
                    if (closest != dir && magneticAccessor.canChangeDirection() && (progress == 1.0f || closest == Direction.UP)) {
                        entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
                        MagnetUtil.setEntityMagneticDirection(entity, closest);
                        entity.m_6210_();
                        entity.m_20124_(Pose.STANDING);
                    }
                } else {
                    entity.m_20256_(entity.m_20184_().m_82549_(vec3));
                }
            }
            MagnetUtil.setEntityMagneticDelta(entity, vec3.m_82490_((double)0.08f));
        }
        if (!attatchesToMagnets && dir != Direction.DOWN) {
            MagnetUtil.setEntityMagneticDirection(entity, Direction.DOWN);
            entity.m_6210_();
            entity.m_20124_(Pose.STANDING);
        }
    }

    public static boolean isEntityOnMovingMetal(Entity entity) {
        return !(entity instanceof MovingMetalBlockEntity) && !entity.m_9236_().m_45976_(MovingMetalBlockEntity.class, entity.m_20191_().m_82400_((double)0.4f)).isEmpty();
    }

    private static Vec3 processMovementControls(float dist, LivingEntity living, Direction dir) {
        float jump;
        double dSpeed = living.m_21133_(Attributes.f_22279_);
        float f = jump = living.f_20899_ && MagnetUtil.getStandingOnMagnetSurface((Entity)living) != null ? 0.75f : -0.1f;
        if (dir == Direction.UP) {
            return new Vec3(living.m_20184_().f_82479_ * 0.98, -living.m_20184_().f_82480_ - (double)jump, living.m_20184_().f_82481_ * 0.98);
        }
        if (dir == Direction.NORTH) {
            return new Vec3((double)(-living.f_20900_) * dSpeed * (double)0.6f, (double)living.f_20902_ * dSpeed, (double)jump);
        }
        if (dir == Direction.SOUTH) {
            return new Vec3((double)living.f_20900_ * dSpeed * (double)0.6f, (double)living.f_20902_ * dSpeed, (double)(-jump));
        }
        if (dir == Direction.EAST) {
            return new Vec3((double)(-jump), (double)living.f_20902_ * dSpeed, (double)(-living.f_20900_) * dSpeed * (double)0.6f);
        }
        if (dir == Direction.WEST) {
            return new Vec3((double)jump, (double)living.f_20902_ * dSpeed, (double)living.f_20900_ * dSpeed * (double)0.6f);
        }
        return living.m_20184_();
    }

    public static Vec3 getEntityMagneticDelta(Entity entity) {
        if (entity instanceof MagneticEntityAccessor) {
            MagneticEntityAccessor magnetic = (MagneticEntityAccessor)entity;
            float f1 = magnetic.getMagneticDeltaX();
            float f2 = magnetic.getMagneticDeltaY();
            float f3 = magnetic.getMagneticDeltaZ();
            if ((double)f1 != 0.0 || (double)f2 != 0.0 || (double)f3 != 0.0) {
                return new Vec3((double)f1, (double)f2, (double)f3);
            }
        }
        return Vec3.f_82478_;
    }

    public static void setEntityMagneticDelta(Entity entity, Vec3 vec3) {
        if (entity instanceof MagneticEntityAccessor) {
            MagneticEntityAccessor magnetic = (MagneticEntityAccessor)entity;
            magnetic.setMagneticDeltaX((float)vec3.f_82479_);
            magnetic.setMagneticDeltaY((float)vec3.f_82480_);
            magnetic.setMagneticDeltaZ((float)vec3.f_82481_);
        }
    }

    public static Direction getEntityMagneticDirection(Entity entity) {
        if (entity instanceof MagneticEntityAccessor) {
            MagneticEntityAccessor magnetic = (MagneticEntityAccessor)entity;
            if (((Boolean)AlexsCaves.COMMON_CONFIG.walkingOnMagnets.get()).booleanValue()) {
                return magnetic.getMagneticAttachmentFace();
            }
        }
        return Direction.DOWN;
    }

    public static void setEntityMagneticDirection(Entity entity, Direction direction) {
        if (entity instanceof MagneticEntityAccessor) {
            MagneticEntityAccessor magnetic = (MagneticEntityAccessor)entity;
            magnetic.setMagneticAttachmentFace(direction);
        }
    }

    private static Direction getStandingOnMagnetSurface(Entity entity) {
        if (entity.m_6144_()) {
            return Direction.DOWN;
        }
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = MagnetUtil.getSamplePosForDirection(entity, dir, 0.1f);
            BlockState blockState = entity.m_9236_().m_8055_(offsetPos);
            if (!blockState.m_204336_(ACTagRegistry.MAGNETIC_ATTACHABLES)) continue;
            return dir;
        }
        return null;
    }

    private static Direction calculateClosestDirection(Entity entity) {
        Direction closestDirection = Direction.DOWN;
        if (entity.m_6144_()) {
            return Direction.DOWN;
        }
        double closestDistance = entity.m_20206_() + entity.m_20205_();
        Vec3 sampleCenter = new Vec3(entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_());
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = MagnetUtil.getSamplePosForDirection(entity, dir, 0.50001f);
            BlockState blockState = entity.m_9236_().m_8055_(offsetPos);
            Vec3 offset = Vec3.m_82512_((Vec3i)offsetPos);
            double dist = sampleCenter.m_82554_(offset);
            if (!(closestDistance > dist) && dir != Direction.UP || !blockState.m_204336_(ACTagRegistry.MAGNETIC_ATTACHABLES)) continue;
            closestDistance = dist;
            closestDirection = dir;
            if (dir == Direction.UP) break;
        }
        return closestDirection;
    }

    private static BlockPos getSamplePosForDirection(Entity entity, Direction direction, float expand) {
        switch (direction) {
            case DOWN: {
                return BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20191_().f_82289_ - (double)expand), (double)entity.m_20189_());
            }
            case UP: {
                return BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20191_().f_82292_ + (double)expand), (double)entity.m_20189_());
            }
            case EAST: {
                return BlockPos.m_274561_((double)(entity.m_20191_().f_82291_ + (double)expand), (double)entity.m_20186_(), (double)entity.m_20189_());
            }
            case WEST: {
                return BlockPos.m_274561_((double)(entity.m_20191_().f_82288_ - (double)expand), (double)entity.m_20186_(), (double)entity.m_20189_());
            }
            case NORTH: {
                return BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)(entity.m_20191_().f_82290_ - (double)expand));
            }
            case SOUTH: {
                return BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)(entity.m_20191_().f_82293_ + (double)expand));
            }
        }
        return entity.m_20183_();
    }

    private static boolean isDynamicallyMagnetic(LivingEntity entity, boolean legsOnly) {
        if (entity.m_21023_((MobEffect)ACEffectRegistry.MAGNETIZING.get())) {
            return true;
        }
        if (legsOnly) {
            return entity.m_6844_(EquipmentSlot.FEET).m_204117_(ACTagRegistry.MAGNETIC_ITEMS);
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!entity.m_6844_(slot).m_204117_(ACTagRegistry.MAGNETIC_ITEMS)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpectatorPlayer(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_5833_();
    }

    public static boolean isPulledByMagnets(Entity entity) {
        LivingEntity living;
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            return item.m_32055_() != null && item.m_32055_().m_204117_(ACTagRegistry.MAGNETIC_ITEMS);
        }
        if (entity instanceof LivingEntity && MagnetUtil.isDynamicallyMagnetic(living = (LivingEntity)entity, false) && !MagnetUtil.isSpectatorPlayer(entity)) {
            return true;
        }
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity block = (FallingBlockEntity)entity;
            return block.m_31980_() != null && block.m_31980_().m_204336_(ACTagRegistry.MAGNETIC_BLOCKS);
        }
        return entity.m_6095_().m_204039_(ACTagRegistry.MAGNETIC_ENTITIES);
    }

    public static boolean attachesToMagnets(Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && MagnetUtil.isDynamicallyMagnetic(living = (LivingEntity)entity, true) && !living.m_6144_()) {
            return true;
        }
        return entity.m_6095_().m_204039_(ACTagRegistry.MAGNETIC_ENTITIES);
    }

    public static void rotateHead(LivingEntity entity) {
        Direction direction = MagnetUtil.getEntityMagneticDirection((Entity)entity);
        if (direction == Direction.UP) {
            float f = entity.m_6080_() - entity.f_20883_;
            float f1 = entity.f_20886_ - entity.f_20884_;
            entity.m_5616_(entity.f_20883_ - f);
            entity.f_20886_ = entity.f_20884_ - f1;
            entity.m_146926_(180.0f - entity.m_146909_());
            entity.f_19860_ = 180.0f - entity.f_19860_;
        } else if (direction != Direction.DOWN) {
            float f = entity instanceof Player ? 90.0f : 0.0f;
            entity.m_146926_(entity.m_146909_() + f);
            entity.f_19860_ += f;
        }
    }

    public static Vec3 getEyePositionForAttachment(Entity entity, Direction face, float partialTicks) {
        float progress = ((MagneticEntityAccessor)entity).getAttachmentProgress(partialTicks);
        double eyeHeight = entity.m_20236_(Pose.STANDING);
        double d0 = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
        Vec3 offset = new Vec3((double)(-face.m_122429_()) * eyeHeight, (double)(-face.m_122430_()) * eyeHeight, (double)(-face.m_122431_()) * eyeHeight);
        Vec3 from = new Vec3(d0, d1 + eyeHeight, d2);
        Vec3 to = new Vec3(d0, d1, d2).m_82549_(offset);
        return from.m_82549_(to.m_82546_(from).m_82490_((double)progress));
    }

    public static List<VoxelShape> getMovingBlockCollisions(@Nullable Entity entity, AABB aabb) {
        if (aabb.m_82309_() < 1.0E-7) {
            return List.of();
        }
        List list = entity.m_9236_().m_6443_(AbstractMovingBlockEntity.class, aabb.m_82400_(1.0E-7), AbstractMovingBlockEntity::movesEntities);
        if (list.isEmpty()) {
            return List.of();
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (AbstractMovingBlockEntity metalEntity : list) {
            if (metalEntity == entity) continue;
            shapes.add(metalEntity.getShape());
        }
        return shapes;
    }

    public static void turnEntityOnMagnet(Entity entity, double xBy, double yBy, Direction magneticAttachmentFace) {
        float progress = ((MagneticEntityAccessor)entity).getAttachmentProgress(AlexsCaves.PROXY.getPartialTicks());
        float f = (float)xBy * 0.15f;
        float f1 = (float)yBy * 0.15f * (magneticAttachmentFace == Direction.UP ? -1.0f : 1.0f);
        float magnetOffset = (float)(magneticAttachmentFace == Direction.UP ? -180 : -90) * progress;
        if ((double)progress > 0.0 && progress < 1.0f) {
            entity.m_146926_(magnetOffset);
        } else {
            entity.m_146926_(entity.m_146909_() + f);
        }
        entity.m_146922_(entity.m_146908_() + f1);
        entity.m_146926_(Mth.m_14036_((float)entity.m_146909_(), (float)(-90.0f + magnetOffset), (float)(90.0f + magnetOffset)));
        entity.f_19860_ += f;
        entity.f_19859_ += f1;
        entity.f_19860_ = Mth.m_14036_((float)entity.f_19860_, (float)(-90.0f + magnetOffset), (float)(90.0f + magnetOffset));
    }

    public static AABB rotateBoundingBox(EntityDimensions dimensions, Direction dir, Vec3 position) {
        float usualWidth = dimensions.f_20377_ * 0.5f;
        switch (dir) {
            case NORTH: {
                return new AABB((double)(dimensions.f_20377_ * -0.5f), (double)(dimensions.f_20377_ * -0.5f), (double)(-usualWidth), (double)(dimensions.f_20377_ * 0.5f), (double)(dimensions.f_20377_ * 0.5f), (double)(dimensions.f_20378_ - usualWidth)).m_82383_(position);
            }
            case SOUTH: {
                return new AABB((double)(dimensions.f_20377_ * -0.5f), (double)(dimensions.f_20377_ * -0.5f), (double)(-dimensions.f_20378_ + usualWidth), (double)(dimensions.f_20377_ * 0.5f), (double)(dimensions.f_20377_ * 0.5f), (double)usualWidth).m_82383_(position);
            }
            case EAST: {
                return new AABB((double)(-dimensions.f_20378_ + usualWidth), (double)(dimensions.f_20377_ * -0.5f), (double)(dimensions.f_20377_ * -0.5f), (double)usualWidth, (double)(dimensions.f_20377_ * 0.5f), (double)(dimensions.f_20377_ * 0.5f)).m_82383_(position);
            }
            case WEST: {
                return new AABB((double)(-usualWidth), (double)(dimensions.f_20377_ * -0.5f), (double)(dimensions.f_20377_ * -0.5f), (double)(dimensions.f_20378_ - usualWidth), (double)(dimensions.f_20377_ * 0.5f), (double)(dimensions.f_20377_ * 0.5f)).m_82383_(position);
            }
        }
        return dimensions.m_20393_(position);
    }
}

