/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.config;

import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRarity;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import com.github.alexthe666.citadel.server.event.EventReplaceBiome;
import java.util.List;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.phys.Vec3;

public class BiomeGenerationNoiseCondition {
    private boolean disabledCompletely;
    private int distanceFromSpawn;
    private final int alexscavesRarityOffset;
    private final float[] continentalness;
    private final float[] erosion;
    private final float[] humidity;
    private final float[] temperature;
    private final float[] weirdness;
    private final float[] depth;
    private final List<String> dimensions;

    private BiomeGenerationNoiseCondition(boolean disabledCompletely, int distanceFromSpawn, int alexscavesRarityOffset, float[] continentalness, float[] erosion, float[] humidity, float[] temperature, float[] weirdness, float[] depth, String[] dimensions) {
        this.disabledCompletely = disabledCompletely;
        this.distanceFromSpawn = distanceFromSpawn;
        this.continentalness = continentalness;
        this.erosion = erosion;
        this.humidity = humidity;
        this.temperature = temperature;
        this.weirdness = weirdness;
        this.depth = depth;
        this.alexscavesRarityOffset = alexscavesRarityOffset;
        this.dimensions = List.of(dimensions);
    }

    @Deprecated(forRemoval=true, since="1.21")
    public boolean test(EventReplaceBiome event, VoronoiGenerator.VoronoiInfo info) {
        if (this.disabledCompletely) {
            return false;
        }
        if (!BiomeGenerationNoiseCondition.isFarEnoughFromSpawn(event, this.distanceFromSpawn)) {
            return false;
        }
        Vec3 rareBiomeCenter = ACBiomeRarity.getRareBiomeCenter(info);
        if (rareBiomeCenter == null) {
            return false;
        }
        Climate.TargetPoint centerTargetPoint = event.getClimateSampler().m_183445_((int)Math.floor(rareBiomeCenter.f_82479_), event.getY(), (int)Math.floor(rareBiomeCenter.f_82481_));
        float f = Climate.m_186796_((long)centerTargetPoint.f_187005_());
        float f1 = Climate.m_186796_((long)centerTargetPoint.f_187006_());
        float f2 = Climate.m_186796_((long)centerTargetPoint.f_187003_());
        float f3 = Climate.m_186796_((long)centerTargetPoint.f_187004_());
        float f4 = Climate.m_186796_((long)centerTargetPoint.f_187008_());
        if (this.continentalness != null && this.continentalness.length >= 2 && (f < this.continentalness[0] || f > this.continentalness[1])) {
            return false;
        }
        if (this.erosion != null && this.erosion.length >= 2 && (f1 < this.erosion[0] || f1 > this.erosion[1])) {
            return false;
        }
        if (this.humidity != null && this.humidity.length >= 2 && (f2 < this.humidity[0] || f2 > this.humidity[1])) {
            return false;
        }
        if (this.temperature != null && this.temperature.length >= 2 && (f3 < this.temperature[0] || f3 > this.temperature[1])) {
            return false;
        }
        if (this.weirdness != null && this.weirdness.length >= 2 && (f4 < this.weirdness[0] || f4 > this.weirdness[1])) {
            return false;
        }
        if (this.depth != null && this.depth.length >= 2 && !event.testDepth(this.depth[0], this.depth[1])) {
            return false;
        }
        return event.getWorldDimension() == null || this.dimensions.contains(event.getWorldDimension().m_135782_().toString());
    }

    @Deprecated(forRemoval=true, since="1.21")
    private static boolean isFarEnoughFromSpawn(EventReplaceBiome event, double dist) {
        int z;
        int x = QuartPos.m_175404_((int)event.getX());
        return (double)(x * x + (z = QuartPos.m_175404_((int)event.getZ())) * z) >= dist * dist;
    }

    public boolean test(int x, int y, int z, float unquantizedDepth, Climate.Sampler climateSampler, ResourceKey<Level> dimension, VoronoiGenerator.VoronoiInfo info) {
        if (this.disabledCompletely) {
            return false;
        }
        if (!BiomeGenerationNoiseCondition.isFarEnoughFromSpawn(x, z, this.distanceFromSpawn)) {
            return false;
        }
        Vec3 rareBiomeCenter = ACBiomeRarity.getRareBiomeCenter(info);
        if (rareBiomeCenter == null) {
            return false;
        }
        Climate.TargetPoint centerTargetPoint = climateSampler.m_183445_((int)Math.floor(rareBiomeCenter.f_82479_), y, (int)Math.floor(rareBiomeCenter.f_82481_));
        float f = Climate.m_186796_((long)centerTargetPoint.f_187005_());
        float f1 = Climate.m_186796_((long)centerTargetPoint.f_187006_());
        float f2 = Climate.m_186796_((long)centerTargetPoint.f_187003_());
        float f3 = Climate.m_186796_((long)centerTargetPoint.f_187004_());
        float f4 = Climate.m_186796_((long)centerTargetPoint.f_187008_());
        if (this.continentalness != null && this.continentalness.length >= 2 && (f < this.continentalness[0] || f > this.continentalness[1])) {
            return false;
        }
        if (this.erosion != null && this.erosion.length >= 2 && (f1 < this.erosion[0] || f1 > this.erosion[1])) {
            return false;
        }
        if (this.humidity != null && this.humidity.length >= 2 && (f2 < this.humidity[0] || f2 > this.humidity[1])) {
            return false;
        }
        if (this.temperature != null && this.temperature.length >= 2 && (f3 < this.temperature[0] || f3 > this.temperature[1])) {
            return false;
        }
        if (this.weirdness != null && this.weirdness.length >= 2 && (f4 < this.weirdness[0] || f4 > this.weirdness[1])) {
            return false;
        }
        if (this.depth != null && this.depth.length >= 2 && (unquantizedDepth < this.depth[0] || unquantizedDepth > this.depth[1])) {
            return false;
        }
        return dimension == null || this.dimensions.contains(dimension.m_135782_().toString());
    }

    private static boolean isFarEnoughFromSpawn(int xIn, int zIn, double dist) {
        int z;
        int x = QuartPos.m_175404_((int)xIn);
        return (double)(x * x + (z = QuartPos.m_175402_((int)zIn)) * z) >= dist * dist;
    }

    public boolean isDisabledCompletely() {
        return this.disabledCompletely;
    }

    public boolean isInvalid() {
        return this.dimensions == null && !this.disabledCompletely;
    }

    public int getRarityOffset() {
        return this.alexscavesRarityOffset;
    }

    public static final class Builder {
        private boolean disabledCompletely;
        private int distanceFromSpawn;
        private float[] alexBiomeRarity;
        private float[] continentalness;
        private float[] erosion;
        private float[] humidity;
        private float[] temperature;
        private float[] weirdness;
        private float[] depth;
        private String[] dimensions;
        private int rarityOffset;

        public Builder disabledCompletely(boolean disabledCompletely) {
            this.disabledCompletely = disabledCompletely;
            return this;
        }

        public Builder alexscavesRarityOffset(int rarityOffset) {
            this.rarityOffset = rarityOffset;
            return this;
        }

        public Builder distanceFromSpawn(int distanceFromSpawn) {
            this.distanceFromSpawn = distanceFromSpawn;
            return this;
        }

        public Builder continentalness(float ... continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public Builder erosion(float ... erosion) {
            this.erosion = erosion;
            return this;
        }

        public Builder humidity(float ... humidity) {
            this.humidity = humidity;
            return this;
        }

        public Builder temperature(float ... temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder weirdness(float ... weirdness) {
            this.weirdness = weirdness;
            return this;
        }

        public Builder depth(float ... depth) {
            this.depth = depth;
            return this;
        }

        public Builder dimensions(String ... dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public BiomeGenerationNoiseCondition build() {
            return new BiomeGenerationNoiseCondition(this.disabledCompletely, this.distanceFromSpawn, this.rarityOffset, this.continentalness, this.erosion, this.humidity, this.temperature, this.weirdness, this.depth, this.dimensions);
        }
    }
}

