/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.GumbeeperEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class GumbeeperModel
extends AdvancedEntityModel<GumbeeperEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox coin_Wheel;
    private final AdvancedModelBox right_backLeg;
    private final AdvancedModelBox left_backLeg;
    private final AdvancedModelBox right_frontLeg;
    private final AdvancedModelBox left_frontLeg;
    private final AdvancedModelBox head;
    private final AdvancedModelBox gum_layers;
    private final AdvancedModelBox gum_layerFinal;
    private final AdvancedModelBox gum_layer6;
    private final AdvancedModelBox gum_layer5;
    private final AdvancedModelBox gum_layer4;
    private final AdvancedModelBox gum_layer3;
    private final AdvancedModelBox gum_layer2;
    private final AdvancedModelBox gum_layer;

    public GumbeeperModel(float f) {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(1.0f, -5.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(16, 49).addBox(-5.0f, -7.0f, -4.0f, 8.0f, 9.0f, 8.0f, f + 0.25f, false);
        this.body.setTextureOffset(40, 40).addBox(-5.0f, -7.0f, -4.0f, 8.0f, 9.0f, 8.0f, f, false);
        this.coin_Wheel = new AdvancedModelBox((AdvancedEntityModel)this);
        this.coin_Wheel.setRotationPoint(-1.0f, -4.0f, -5.0f);
        this.body.addChild((BasicModelPart)this.coin_Wheel);
        this.coin_Wheel.setTextureOffset(0, 0).addBox(0.0f, -2.0f, -1.0f, 0.0f, 4.0f, 2.0f, f, false);
        this.right_backLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_backLeg.setRotationPoint(-4.0f, 1.0f, 3.0f);
        this.body.addChild((BasicModelPart)this.right_backLeg);
        this.right_backLeg.setTextureOffset(52, 26).addBox(-3.0f, -1.0f, -1.0f, 4.0f, 5.0f, 4.0f, f, true);
        this.left_backLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_backLeg.setRotationPoint(2.0f, 1.0f, 3.0f);
        this.body.addChild((BasicModelPart)this.left_backLeg);
        this.left_backLeg.setTextureOffset(52, 26).addBox(-1.0f, -1.0f, -1.0f, 4.0f, 5.0f, 4.0f, f, false);
        this.right_frontLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_frontLeg.setRotationPoint(-4.0f, 1.0f, -3.0f);
        this.body.addChild((BasicModelPart)this.right_frontLeg);
        this.right_frontLeg.setTextureOffset(36, 26).addBox(-3.0f, -1.0f, -3.0f, 4.0f, 5.0f, 4.0f, f, true);
        this.left_frontLeg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_frontLeg.setRotationPoint(2.0f, 1.0f, -3.0f);
        this.body.addChild((BasicModelPart)this.left_frontLeg);
        this.left_frontLeg.setTextureOffset(36, 26).addBox(-1.0f, -1.0f, -3.0f, 4.0f, 5.0f, 4.0f, f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(-1.0f, -7.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 24).addBox(-6.0f, -14.0f, -6.0f, 12.0f, 12.0f, 12.0f, f, false);
        this.head.setTextureOffset(36, 12).addBox(-6.0f, -2.0f, -6.0f, 12.0f, 2.0f, 12.0f, f, false);
        this.head.setTextureOffset(36, 0).addBox(-4.0f, -17.0f, -4.0f, 8.0f, 3.0f, 8.0f, f, false);
        this.gum_layers = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layers.setRotationPoint(-0.5f, -7.75f, -0.5f);
        this.head.addChild((BasicModelPart)this.gum_layers);
        this.gum_layerFinal = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layerFinal.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layerFinal);
        if (f <= 0.0f) {
            this.gum_layerFinal.setTextureOffset(2, 7).addBox(-5.0f, 0.25f, -5.0f, 11.0f, 6.0f, 11.0f, f, false);
        }
        this.gum_layer6 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layer6.setRotationPoint(0.0f, -3.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layer6);
        if (f <= 0.0f) {
            this.gum_layer6.setTextureOffset(2, 6).addBox(-5.0f, 2.25f, -5.0f, 11.0f, 1.0f, 11.0f, f, false);
        }
        this.gum_layer5 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layer5.setRotationPoint(0.0f, -4.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layer5);
        if (f <= 0.0f) {
            this.gum_layer5.setTextureOffset(2, 5).addBox(-5.0f, 2.25f, -5.0f, 11.0f, 1.0f, 11.0f, f, false);
        }
        this.gum_layer4 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layer4.setRotationPoint(0.0f, -5.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layer4);
        if (f <= 0.0f) {
            this.gum_layer4.setTextureOffset(2, 4).addBox(-5.0f, 2.25f, -5.0f, 11.0f, 1.0f, 11.0f, f, false);
        }
        this.gum_layer3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layer3.setRotationPoint(0.0f, -6.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layer3);
        if (f <= 0.0f) {
            this.gum_layer3.setTextureOffset(2, 3).addBox(-5.0f, 2.25f, -5.0f, 11.0f, 1.0f, 11.0f, f, false);
        }
        this.gum_layer2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layer2.setRotationPoint(0.0f, -7.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layer2);
        if (f <= 0.0f) {
            this.gum_layer2.setTextureOffset(2, 2).addBox(-5.0f, 2.25f, -5.0f, 11.0f, 1.0f, 11.0f, f, false);
        }
        this.gum_layer = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_layer.setRotationPoint(0.0f, -8.0f, 0.0f);
        this.gum_layers.addChild((BasicModelPart)this.gum_layer);
        if (f <= 0.0f) {
            this.gum_layer.setTextureOffset(2, 1).addBox(-5.0f, 2.25f, -5.0f, 11.0f, 1.0f, 11.0f, f, false);
        }
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.body, (Object)this.head, (Object)this.gum_layer, (Object)this.gum_layers, (Object)this.gum_layer2, (Object)this.gum_layer3, (Object)this.gum_layer4, (Object)this.gum_layer5, (Object)this.gum_layer6, (Object)this.gum_layerFinal, (Object)this.coin_Wheel, (Object[])new AdvancedModelBox[]{this.left_backLeg, this.left_frontLeg, this.right_backLeg, this.right_frontLeg});
    }

    public void setupAnim(GumbeeperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float walkSpeed = 0.8f;
        float walkDegree = 1.2f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float explodeProgress = entity.getExplodeProgress(partialTick);
        float dialRot = (float)Math.toRadians(entity.getDialRot(partialTick));
        float dialRotFinalStretch = Math.max(dialRot - 400.0f, 0.0f) / 50.0f;
        float shootProgress = entity.getShootProgress(partialTick);
        int gumballsLeft = entity.getGumballsLeft();
        this.gum_layer6.showModel = gumballsLeft > 0;
        this.gum_layer5.showModel = gumballsLeft > 1;
        this.gum_layer4.showModel = gumballsLeft > 2;
        this.gum_layer3.showModel = gumballsLeft > 3;
        this.gum_layer2.showModel = gumballsLeft > 4;
        this.gum_layer.showModel = gumballsLeft > 5;
        this.progressRotationPrev(this.body, shootProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, shootProgress, (float)Math.toRadians(-5.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.left_backLeg, shootProgress, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.right_backLeg, shootProgress, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.left_frontLeg, shootProgress, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.right_frontLeg, shootProgress, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.body, shootProgress, 0.0f, -1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.head, shootProgress, 0.0f, 1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.right_frontLeg, shootProgress, 0.0f, 2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.left_frontLeg, shootProgress, 0.0f, 2.0f, 0.0f, 1.0f);
        this.coin_Wheel.rotateAngleZ += dialRot;
        this.coin_Wheel.rotationPointZ += dialRotFinalStretch * 1.5f;
        this.body.setScale(1.0f + explodeProgress * 0.15f, 1.0f - explodeProgress * 0.2f, 1.0f + explodeProgress * 0.15f);
        this.body.scaleChildren = true;
        float bodyBob = ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed * 1.5f, 0.5f, 0.5f, true);
        this.body.rotationPointY += bodyBob;
        this.walk(this.right_frontLeg, walkSpeed, walkDegree * 0.4f, true, 2.5f, 0.2f, limbSwing, limbSwingAmount);
        this.right_frontLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, 0.0f, 4.0f, false)) - bodyBob;
        this.walk(this.left_frontLeg, walkSpeed, walkDegree * 0.4f, false, 2.5f, -0.2f, limbSwing, limbSwingAmount);
        this.left_frontLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, 0.0f, 4.0f, true)) - bodyBob;
        this.walk(this.right_backLeg, walkSpeed, walkDegree * 0.4f, false, 2.5f, 0.2f, limbSwing, limbSwingAmount);
        this.right_backLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, 0.0f, 4.0f, true)) - bodyBob;
        this.walk(this.left_backLeg, walkSpeed, walkDegree * 0.4f, true, 2.5f, -0.2f, limbSwing, limbSwingAmount);
        this.left_backLeg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, 0.0f, 4.0f, false)) - bodyBob;
        this.swing(this.body, 3.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, explodeProgress);
        this.swing(this.head, 1.3f, 0.1f, true, 1.0f, 0.0f, ageInTicks, shootProgress);
    }
}

