/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.registration.tracking;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.moddingx.libx.impl.registration.tracking.TrackingData;

public class RegistryTracker {
    private static final Object LOCK = new Object();
    private static boolean registeredToObjectHolders = false;
    private static final Map<ResourceLocation, TrackingData<?>> trackedRegistries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void track(IForgeRegistry<T> registry, Field field, ResourceLocation id) {
        Object object = LOCK;
        synchronized (object) {
            RegistryTracker.trackingData(registry).addStatic(id, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void track(IForgeRegistry<T> registry, Field field, Object instance, ResourceLocation id) {
        Object object = LOCK;
        synchronized (object) {
            RegistryTracker.trackingData(registry).addInstance(id, field, instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void run(IForgeRegistry<T> registry, Consumer<T> action, Object instance, ResourceLocation id) {
        Object object = LOCK;
        synchronized (object) {
            RegistryTracker.trackingData(registry).addAction(id, instance, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> TrackingData<T> trackingData(IForgeRegistry<T> registry) {
        Object object = LOCK;
        synchronized (object) {
            if (!registeredToObjectHolders) {
                ObjectHolderRegistry.addHandler((Consumer)new UpdateConsumer());
                registeredToObjectHolders = true;
            }
            return trackedRegistries.computeIfAbsent(registry.getRegistryName(), k -> new TrackingData(registry));
        }
    }

    private static class UpdateConsumer
    implements Consumer<Predicate<ResourceLocation>> {
        private final List<Runnable> enqueuedTasks = new ArrayList<Runnable>();
        private final Set<Object> objectsToUpdate = new HashSet<Object>();

        private UpdateConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Predicate<ResourceLocation> changed) {
            Predicate<ResourceLocation> registryChanged = changed;
            Predicate<Object> instanceChanged = null;
            this.enqueuedTasks.clear();
            this.objectsToUpdate.clear();
            do {
                this.enqueuedTasks.forEach(Runnable::run);
                this.enqueuedTasks.clear();
                this.objectsToUpdate.clear();
                Object object = LOCK;
                synchronized (object) {
                    for (Map.Entry<ResourceLocation, TrackingData<?>> entry : trackedRegistries.entrySet()) {
                        entry.getValue().apply(registryChanged, instanceChanged, this.enqueuedTasks::add, this.objectsToUpdate::add);
                    }
                    Set<Object> objectsNextRound = Set.copyOf(this.objectsToUpdate);
                    instanceChanged = objectsNextRound::contains;
                    registryChanged = rl -> true;
                }
            } while (!this.enqueuedTasks.isEmpty() || !this.objectsToUpdate.isEmpty());
        }
    }
}

