/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.moddingx.libx.codec.CodecHelper;

public interface TypedEncoder<T, R> {
    public Class<R> resultClass();

    public DataResult<R> encode(T var1);

    public DataResult<T> decode(R var1);

    @Nullable
    default public <N> TypedEncoder<T, N> cast(DynamicOps<N> ops) {
        if (this.resultClass().isAssignableFrom(ops.empty().getClass())) {
            return this;
        }
        return null;
    }

    public static <T, R> TypedEncoder<T, R> of(final Class<R> resultClass, final Function<? super T, ? extends R> encoder, final Function<? super R, ? extends T> decoder) {
        return new TypedEncoder<T, R>(){

            @Override
            public Class<R> resultClass() {
                return resultClass;
            }

            @Override
            public DataResult<R> encode(T value) {
                return CodecHelper.doesNotThrow(() -> encoder.apply(value));
            }

            @Override
            public DataResult<T> decode(R value) {
                return CodecHelper.doesNotThrow(() -> decoder.apply(value));
            }
        };
    }
}

