/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Color;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.Entry<E>>
extends DynamicEntryListWidget<E> {
    protected boolean smoothScrolling = true;
    protected final NumberAnimator<Double> scrollAnimator = ValueAnimator.ofDouble();

    public DynamicSmoothScrollingEntryListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void capYPosition(double scroll) {
        if (!this.smoothScrolling) {
            this.scrollAnimator.setAs(class_3532.method_15350((double)scroll, (double)0.0, (double)this.getMaxScroll()));
        } else {
            this.scrollAnimator.setAs(ScrollingContainer.clampExtension(scroll, this.getMaxScroll()));
        }
        this.scroll = (Double)this.scrollAnimator.value();
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.smoothScrolling) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.getFocused() != null && this.method_25397() && button == 0 && this.getFocused().method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(class_3532.method_15350((double)(this.getScroll() + deltaY * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        for (DynamicEntryListWidget.Entry entry : this.visibleChildren()) {
            if (!entry.method_25401(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        if (amountY == 0.0) {
            return false;
        }
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -amountY;
            this.scroll = class_3532.method_15350((double)amountY, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
        return true;
    }

    public void offset(double value, boolean animated) {
        this.scrollTo((Double)this.scrollAnimator.target() + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        if (animated) {
            this.scrollAnimator.setTo(value, duration);
        } else {
            this.scrollAnimator.setAs(value);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.scrollAnimator.setTarget(ScrollingContainer.handleBounceBack((Double)this.scrollAnimator.target(), this.getMaxScroll(), delta));
        this.scrollAnimator.update(delta);
        this.scroll = (Double)this.scrollAnimator.value();
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    @Override
    protected void renderScrollBar(class_332 graphics, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(graphics, maxScroll, scrollbarPositionMinX, scrollbarPositionMaxX);
        } else if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
            int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
            graphics.method_25294(scrollbarPositionMinX, this.top, scrollbarPositionMaxX, this.bottom, -16777216);
            graphics.method_25294(scrollbarPositionMinX, minY, scrollbarPositionMaxX, minY + height, Color.ofRGB((int)bottomc, (int)bottomc, (int)bottomc).getColor());
            graphics.method_25294(scrollbarPositionMinX, minY, scrollbarPositionMaxX - 1, minY + height - 1, Color.ofRGB((int)topc, (int)topc, (int)topc).getColor());
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
        }
    }
}

