/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.pipeline.compression;

import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import me.steinborn.krypton.mod.shared.misc.KryptonPipelineEvent;
import me.steinborn.krypton.mod.shared.network.compression.MinecraftCompressDecoder;
import me.steinborn.krypton.mod.shared.network.compression.MinecraftCompressEncoder;
import net.minecraft.class_2532;
import net.minecraft.class_2534;
import net.minecraft.class_2535;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2535.class})
public class ClientConnectionMixin {
    @Shadow
    private Channel field_11651;

    @Inject(method={"setCompressionThreshold"}, at={@At(value="HEAD")}, cancellable=true)
    public void setCompressionThreshold(int compressionThreshold, boolean validate, CallbackInfo ci) {
        if (compressionThreshold < 0) {
            if (ClientConnectionMixin.isKryptonOrVanillaDecompressor(this.field_11651.pipeline().get("decompress"))) {
                this.field_11651.pipeline().remove("decompress");
            }
            if (ClientConnectionMixin.isKryptonOrVanillaCompressor(this.field_11651.pipeline().get("compress"))) {
                this.field_11651.pipeline().remove("compress");
            }
            this.field_11651.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_DISABLED);
        } else {
            MinecraftCompressDecoder decoder = (MinecraftCompressDecoder)this.field_11651.pipeline().get("decompress");
            MinecraftCompressEncoder encoder = (MinecraftCompressEncoder)this.field_11651.pipeline().get("compress");
            if (decoder != null && encoder != null) {
                decoder.setThreshold(compressionThreshold);
                encoder.setThreshold(compressionThreshold);
                this.field_11651.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_THRESHOLD_UPDATED);
            } else {
                VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(4);
                encoder = new MinecraftCompressEncoder(compressionThreshold, compressor);
                decoder = new MinecraftCompressDecoder(compressionThreshold, validate, compressor);
                this.field_11651.pipeline().addBefore("decoder", "decompress", (ChannelHandler)decoder);
                this.field_11651.pipeline().addBefore("encoder", "compress", (ChannelHandler)encoder);
                this.field_11651.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_ENABLED);
            }
        }
        ci.cancel();
    }

    private static boolean isKryptonOrVanillaDecompressor(Object o) {
        return o instanceof class_2532 || o instanceof MinecraftCompressDecoder;
    }

    private static boolean isKryptonOrVanillaCompressor(Object o) {
        return o instanceof class_2534 || o instanceof MinecraftCompressEncoder;
    }
}

