/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.item.registry;

import com.cerbon.cerbons_api.api.item.enums.ToolType;
import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistries;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8051;
import net.minecraft.class_9886;

public class ItemRegistry {
    private final String modId;
    private final ResourcefulRegistry<class_1792> itemRegistry;

    public ItemRegistry(String modId) {
        this.modId = modId;
        this.itemRegistry = ResourcefulRegistries.create(class_7923.field_41178, modId);
    }

    public Map<class_8051, RegistryEntry<class_1792>> registerFullArmorSet(class_1741 material) {
        return this.registerFullArmorSet(material, properties -> properties);
    }

    public Map<class_8051, RegistryEntry<class_1792>> registerFullArmorSet(class_1741 material, UnaryOperator<class_1792.class_1793> itemProperties) {
        return ImmutableMap.of((Object)class_8051.field_41934, this.registerArmor(class_8051.field_41934, material, itemProperties), (Object)class_8051.field_41935, this.registerArmor(class_8051.field_41935, material, itemProperties), (Object)class_8051.field_41936, this.registerArmor(class_8051.field_41936, material, itemProperties), (Object)class_8051.field_41937, this.registerArmor(class_8051.field_41937, material, itemProperties));
    }

    public RegistryEntry<class_1792> registerArmor(class_8051 armorType, class_1741 material) {
        return this.registerArmor(armorType, material, properties -> properties);
    }

    public RegistryEntry<class_1792> registerArmor(class_8051 armorType, class_1741 material, UnaryOperator<class_1792.class_1793> itemProperties) {
        String materialName = material.comp_3168().method_29177().method_12832();
        String id = materialName + "_" + armorType.method_15434();
        return this.registerItem(() -> new class_1792(((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_66332(material, armorType))).method_63686(this.makeId(id))), id);
    }

    public RegistryEntry<class_1792> registerTool(ToolType toolType, class_9886 toolMaterial, float attackDamage, float attackSpeed, String id) {
        return this.registerTool(toolType, toolMaterial, properties -> properties, attackDamage, attackSpeed, id);
    }

    public RegistryEntry<class_1792> registerTool(ToolType toolType, class_9886 toolMaterial, UnaryOperator<class_1792.class_1793> itemProperties, float attackDamage, float attackSpeed, String id) {
        return switch (toolType) {
            default -> throw new MatchException(null, null);
            case ToolType.SWORD -> this.registerItem(() -> new class_1792((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_66333(toolMaterial, attackDamage, attackSpeed).method_63686(this.makeId(id)))), id);
            case ToolType.PICKAXE -> this.registerItem(() -> new class_1792((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_66330(toolMaterial, attackDamage, attackSpeed).method_63686(this.makeId(id)))), id);
            case ToolType.AXE -> this.registerItem(() -> new class_1792((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_67190(toolMaterial, attackDamage, attackSpeed).method_63686(this.makeId(id)))), id);
            case ToolType.SHOVEL -> this.registerItem(() -> new class_1792((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_67193(toolMaterial, attackDamage, attackSpeed).method_63686(this.makeId(id)))), id);
            case ToolType.HOE -> this.registerItem(() -> new class_1792((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_67192(toolMaterial, attackDamage, attackSpeed).method_63686(this.makeId(id)))), id);
        };
    }

    public RegistryEntry<class_1792> registerFood(class_4174 foodProperties, String id) {
        return this.registerFood(foodProperties, properties -> properties, id);
    }

    public RegistryEntry<class_1792> registerFood(class_4174 foodProperties, UnaryOperator<class_1792.class_1793> itemProperties, String id) {
        return this.registerItem((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_19265(foodProperties)), id);
    }

    public RegistryEntry<class_1747> registerBlockItem(Supplier<class_2248> block, String id) {
        return this.registerBlockItem(block, new class_1792.class_1793(), id);
    }

    public RegistryEntry<class_1747> registerBlockItem(Supplier<class_2248> block, class_1792.class_1793 itemProperties, String id) {
        return this.registerBlockItem(id, () -> new class_1747((class_2248)block.get(), itemProperties.method_63686(this.makeId(id))));
    }

    public RegistryEntry<class_1747> registerBlockItem(String id, Supplier<class_1747> blockItem) {
        return this.registerItem(blockItem, id);
    }

    public RegistryEntry<class_1792> registerItem(String id) {
        return this.registerItem(new class_1792.class_1793(), id);
    }

    public RegistryEntry<class_1792> registerItem(class_1792.class_1793 itemProperties, String id) {
        return this.registerItem(() -> new class_1792(itemProperties.method_63686(this.makeId(id))), id);
    }

    public <T extends class_1792> RegistryEntry<T> registerItem(Supplier<T> item, String id) {
        return this.itemRegistry.register(id, item);
    }

    public class_5321<class_1792> makeId(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)this.modId, (String)id));
    }

    public Collection<RegistryEntry<class_1792>> getEntries() {
        return this.itemRegistry.getEntries();
    }

    public Stream<RegistryEntry<class_1792>> stream() {
        return this.itemRegistry.stream();
    }

    public Stream<class_1792> boundStream() {
        return this.itemRegistry.boundStream();
    }

    public void register() {
        this.itemRegistry.register();
    }
}

