/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.PlayerUtils;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record TeleportPacket() implements class_8710
{
    public static final class_8710.class_9154<TeleportPacket> PACKET_ID = new class_8710.class_9154(class_2960.method_60655((String)"explorerscompass", (String)"teleport"));
    public static final class_9139<class_9129, TeleportPacket> PACKET_CODEC = class_9139.method_56438(TeleportPacket::write, TeleportPacket::read);

    public static TeleportPacket read(class_9129 buf) {
        return new TeleportPacket();
    }

    public void write(class_9129 buf) {
    }

    public static void apply(TeleportPacket packet, ServerPlayNetworking.Context context) {
        context.player().method_5682().execute(() -> {
            class_1799 stack = ItemUtils.getHeldItem((class_1657)context.player(), ExplorersCompass.EXPLORERS_COMPASS_ITEM);
            if (!stack.method_7960()) {
                ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.method_7909();
                if (ExplorersCompassConfig.allowTeleport && PlayerUtils.canTeleport((class_1657)context.player())) {
                    if (explorersCompass.getState(stack) == CompassState.FOUND) {
                        int x = explorersCompass.getFoundStructureX(stack);
                        int z = explorersCompass.getFoundStructureZ(stack);
                        int y = TeleportPacket.findValidTeleportHeight(context.player().method_5770(), x, z);
                        context.player().method_5848();
                        context.player().field_13987.method_14363((double)x, (double)y, (double)z, context.player().method_36454(), context.player().method_36455());
                        if (!context.player().method_6128()) {
                            context.player().method_18800(context.player().method_18798().method_10216(), 0.0, context.player().method_18798().method_10215());
                            context.player().method_24830(true);
                        }
                    }
                } else {
                    ExplorersCompass.LOGGER.warn("Player " + context.player().method_5476().getString() + " tried to teleport but does not have permission.");
                }
            }
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    private static int findValidTeleportHeight(class_1937 world, int x, int z) {
        int upY = world.method_8615();
        int downY = world.method_8615();
        while (!(world.method_31601(upY) && world.method_31601(downY) || TeleportPacket.isValidTeleportPosition(world, new class_2338(x, upY, z)) || TeleportPacket.isValidTeleportPosition(world, new class_2338(x, downY, z)))) {
            ++upY;
            --downY;
        }
        class_2338 upPos = new class_2338(x, upY, z);
        class_2338 downPos = new class_2338(x, downY, z);
        if (TeleportPacket.isValidTeleportPosition(world, upPos)) {
            return upY;
        }
        if (TeleportPacket.isValidTeleportPosition(world, downPos)) {
            return downY;
        }
        return 256;
    }

    private static boolean isValidTeleportPosition(class_1937 world, class_2338 pos) {
        return TeleportPacket.isFree(world, pos) && TeleportPacket.isFree(world, pos.method_10084()) && !TeleportPacket.isFree(world, pos.method_10074());
    }

    private static boolean isFree(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26215() || world.method_8320(pos).method_26164(class_3481.field_21952) || world.method_8320(pos).method_51176() || world.method_8320(pos).method_45474();
    }
}

