/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ContainerScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.Hint;
import net.blay09.mods.trashslot.client.LayoutManager;
import net.blay09.mods.trashslot.client.ModKeyMappings;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.TrashSlotComponent;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class TrashSlotGuiHandler {
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = class_2960.method_60656((String)"container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/slot_highlight_front");
    private static final TrashSlotSlot trashSlot = new TrashSlotSlot();
    private static TrashSlotComponent trashSlotComponent;
    private static ContainerSettings currentContainerSettings;
    private static boolean ignoreMouseUp;
    private static boolean sentMissingMessage;
    private static boolean isLeftMouseDown;
    private static Hint currentHint;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, TrashSlotGuiHandler::onScreenInit);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, TrashSlotGuiHandler::onMouseRelease);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, TrashSlotGuiHandler::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, TrashSlotGuiHandler::onKeyPress);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onBackgroundDrawn);
    }

    private static void onScreenInit(ScreenInitEvent.Post event) {
        if (event.getScreen().getClass().getName().startsWith("com.replaymod")) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_7325()) {
            return;
        }
        if (event.getScreen() instanceof class_481) {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            if (!TrashSlot.isServerSideInstalled && !sentMissingMessage) {
                TrashSlot.logger.info("TrashSlot is not installed on the server and thus will be unavailable.");
                class_5250 noHabloEspanol = class_2561.method_43471((String)"trashslot.serverNotInstalled");
                noHabloEspanol.method_27692(class_124.field_1061);
                TrashSlotGuiHandler.showHint("serverNotInstalled", noHabloEspanol, 5000, true);
                sentMissingMessage = true;
                return;
            }
            if (screen instanceof class_490 && player != null && player.method_31549().field_7477) {
                return;
            }
            IGuiContainerLayout layout = LayoutManager.getLayout(screen);
            currentContainerSettings = TrashSlotSaveState.getSettings(screen, layout);
            if (currentContainerSettings != ContainerSettings.NONE) {
                trashSlotComponent = new TrashSlotComponent(screen, layout, currentContainerSettings, trashSlot);
                if (!(currentContainerSettings.isEnabled() || layout.isEnabledByDefault() || ModKeyMappings.keyBindToggleSlot.getBinding().key().equals((Object)class_3675.field_16237))) {
                    class_5250 hintMessage = class_2561.method_43469((String)"trashslot.hint.toggleOn", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlot.getBinding().key().method_27445()});
                    TrashSlotGuiHandler.showHint("toggleOn", hintMessage, 5000);
                }
            } else {
                trashSlotComponent = null;
            }
        } else {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
        }
    }

    private static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        if (event.getButton() == 0) {
            isLeftMouseDown = false;
        }
        if (ignoreMouseUp) {
            event.setCanceled(true);
            ignoreMouseUp = false;
        }
    }

    private static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        DeletionProvider deletionProvider;
        if (event.getButton() == 0) {
            isLeftMouseDown = true;
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        int mouseButton = event.getButton();
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), mouseButton, 0, 0)) {
            event.setCanceled(true);
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            double mouseY;
            class_465 screen = (class_465)class_4372;
            double mouseX = event.getMouseX();
            if (((AbstractContainerScreenAccessor)screen).callIsHovering((class_1735)trashSlot, mouseX, mouseY = event.getMouseY())) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    boolean isRightClick;
                    class_1799 mouseItem = screen.method_17577().method_34255();
                    boolean bl = isRightClick = mouseButton == 1;
                    if (mouseItem.method_7960()) {
                        deletionProvider.undeleteLast((class_1657)player, trashSlot, isRightClick);
                    } else {
                        class_2960 registryName = class_7923.field_41178.method_10221((Object)mouseItem.method_7909());
                        if (registryName == null || !TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
                            deletionProvider.deleteMouseItem((class_1657)player, mouseItem, trashSlot, isRightClick);
                        } else {
                            class_5250 hintMessage = class_2561.method_43471((String)"trashslot.hint.deletionDenied");
                            hintMessage.method_27692(class_124.field_1061);
                            TrashSlotGuiHandler.showHint("deletionDenied", hintMessage, 1000, true);
                        }
                    }
                    event.setCanceled(true);
                    ignoreMouseUp = true;
                }
            } else if (trashSlotComponent.isInside((int)mouseX, (int)mouseY)) {
                event.setCanceled(true);
                ignoreMouseUp = true;
            }
        }
    }

    private static void onKeyPress(ScreenKeyEvent.Press.Post event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return;
        }
        int keyCode = event.getKey();
        int scanCode = event.getScanCode();
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), keyCode, scanCode, event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    private static boolean runKeyBindings(class_437 screen, int keyCode, int scanCode, int modifiers) {
        class_1735 mouseSlot;
        class_481 containerScreen;
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        boolean isDelete = ModKeyMappings.keyBindDelete.isActiveAndMatchesKey(keyCode, scanCode, modifiers);
        boolean isDeleteAll = ModKeyMappings.keyBindDeleteAll.isActiveAndMatchesKey(keyCode, scanCode, modifiers);
        class_746 player = class_310.method_1551().field_1724;
        if ((isDelete || isDeleteAll) && TrashSlotConfig.getActive().enableDeleteKeysInCreative && screen instanceof class_481) {
            containerScreen = (class_481)screen;
            if (player != null) {
                mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                DeletionProvider creativeDeletionProvider = TrashSlotConfig.getCreativeDeletionProvider();
                if (mouseSlot != null && mouseSlot.getClass() == class_1735.class) {
                    creativeDeletionProvider.deleteContainerItem((class_1657)player, containerScreen.method_17577(), mouseSlot.field_7874 - 9, isDeleteAll, trashSlot);
                } else if (mouseSlot != null && mouseSlot.getClass().getSimpleName().equals("SlotWrapper")) {
                    creativeDeletionProvider.deleteContainerItem((class_1657)player, containerScreen.method_17577(), mouseSlot.method_34266(), isDeleteAll, trashSlot);
                }
            }
        }
        if ((currentContainerSettings.isEnabled() || TrashSlotConfig.getActive().allowDeletionWhileTrashSlotIsInvisible) && (isDelete || isDeleteAll) && player != null && screen instanceof class_465) {
            containerScreen = (class_465)screen;
            mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (mouseSlot != null && mouseSlot.method_7681()) {
                class_2960 registryName = class_7923.field_41178.method_10221((Object)mouseSlot.method_7677().method_7909());
                if (registryName == null || !TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
                    deletionProvider.deleteContainerItem((class_1657)player, containerScreen.method_17577(), mouseSlot.field_7874, isDeleteAll, trashSlot);
                    if (!currentContainerSettings.isEnabled()) {
                        class_5250 hintMessage = class_2561.method_43471((String)"trashslot.hint.deletedWhileHidden");
                        hintMessage.method_27692(class_124.field_1065);
                        TrashSlotGuiHandler.showHint("deletedWhileHidden", hintMessage, 800, true);
                    }
                } else {
                    class_5250 hintMessage = class_2561.method_43471((String)"trashslot.hint.deletionDenied");
                    hintMessage.method_27692(class_124.field_1061);
                    TrashSlotGuiHandler.showHint("deletionDenied", hintMessage, 1000, true);
                }
            } else {
                double mouseY;
                class_1041 mainWindow = class_310.method_1551().method_22683();
                double rawMouseX = class_310.method_1551().field_1729.method_1603();
                double rawMouseY = class_310.method_1551().field_1729.method_1604();
                double mouseX = rawMouseX * (double)mainWindow.method_4486() / (double)mainWindow.method_4489();
                if (((AbstractContainerScreenAccessor)containerScreen).callIsHovering((class_1735)trashSlot, mouseX, mouseY = rawMouseY * (double)mainWindow.method_4502() / (double)mainWindow.method_4506())) {
                    deletionProvider.emptyTrashSlot((class_1657)player, trashSlot);
                }
            }
            return true;
        }
        if (screen instanceof class_465 && currentContainerSettings != ContainerSettings.NONE) {
            class_5250 hintMessage;
            if (ModKeyMappings.keyBindToggleSlot.isActiveAndMatchesKey(keyCode, scanCode, modifiers)) {
                currentContainerSettings.setEnabled(!currentContainerSettings.isEnabled());
                if (!currentContainerSettings.isEnabled() && !ModKeyMappings.keyBindToggleSlot.getBinding().key().equals((Object)class_3675.field_16237)) {
                    hintMessage = class_2561.method_43469((String)"trashslot.hint.toggledOff", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlot.getBinding().key().method_27445()});
                    TrashSlotGuiHandler.showHint("toggledOff", hintMessage, 5000);
                }
                TrashSlotSaveState.save();
                return true;
            }
            if (ModKeyMappings.keyBindToggleSlotLock.isActiveAndMatchesKey(keyCode, scanCode, modifiers)) {
                currentContainerSettings.setLocked(!currentContainerSettings.isLocked());
                if (currentContainerSettings.isLocked()) {
                    hintMessage = class_2561.method_43469((String)"trashslot.hint.locked", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlotLock.getBinding().key().method_27445()});
                    hintMessage.method_27692(class_124.field_1065);
                    TrashSlotGuiHandler.showHint("locked", hintMessage, 5000, true);
                } else {
                    hintMessage = class_2561.method_43469((String)"trashslot.hint.unlocked", (Object[])new Object[]{ModKeyMappings.keyBindToggleSlotLock.getBinding().key().method_27445()});
                    hintMessage.method_27692(class_124.field_1065);
                    TrashSlotGuiHandler.showHint("unlocked", hintMessage, 5000, true);
                }
                TrashSlotSaveState.save();
                return true;
            }
        }
        return false;
    }

    private static void showHint(String id, class_5250 message, int timeToDisplay) {
        TrashSlotGuiHandler.showHint(id, message, timeToDisplay, false);
    }

    private static void showHint(String id, class_5250 message, int timeToDisplay, boolean force) {
        TrashSlotSaveState saveState = TrashSlotSaveState.getInstance();
        if (force || !saveState.hasSeenHint(id) && TrashSlotConfig.getActive().enableHints) {
            currentHint = new Hint(id, (class_2561)message, timeToDisplay);
        }
    }

    public static void onBackgroundDrawn(ContainerScreenDrawEvent.Background event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            if (trashSlotComponent != null) {
                boolean isMouseSlot;
                trashSlotComponent.update(event.getMouseX(), event.getMouseY());
                trashSlotComponent.drawBackground(event.getGuiGraphics());
                class_4587 poseStack = event.getGuiGraphics().method_51448();
                AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
                boolean hovering = screenAccessor.callIsHovering((class_1735)trashSlot, (double)event.getMouseX(), (double)event.getMouseY());
                if (hovering) {
                    poseStack.method_22903();
                    poseStack.method_46416((float)screenAccessor.getLeftPos(), (float)screenAccessor.getTopPos(), 1.0f);
                    event.getGuiGraphics().method_52706(class_1921::method_62277, SLOT_HIGHLIGHT_BACK_SPRITE, TrashSlotGuiHandler.trashSlot.field_7873 - 4, TrashSlotGuiHandler.trashSlot.field_7872 - 4, 24, 24);
                    poseStack.method_22909();
                }
                TrashSlotSlot trashSlot = TrashSlotGuiHandler.trashSlot;
                SlotAccessor slotAccessor = (SlotAccessor)trashSlot;
                slotAccessor.setX(trashSlot.field_7873 + screenAccessor.getLeftPos());
                slotAccessor.setY(trashSlot.field_7872 + screenAccessor.getTopPos());
                screenAccessor.callRenderSlot(event.getGuiGraphics(), (class_1735)trashSlot);
                slotAccessor.setX(trashSlot.field_7873 - screenAccessor.getLeftPos());
                slotAccessor.setY(trashSlot.field_7872 - screenAccessor.getTopPos());
                if (hovering) {
                    poseStack.method_22903();
                    poseStack.method_46416((float)screenAccessor.getLeftPos(), (float)screenAccessor.getTopPos(), 300.0f);
                    event.getGuiGraphics().method_52706(class_1921::method_62277, SLOT_HIGHLIGHT_FRONT_SPRITE, trashSlot.field_7873 - 4, trashSlot.field_7872 - 4, 24, 24);
                    poseStack.method_22909();
                }
                if (isMouseSlot = screenAccessor.callIsHovering((class_1735)trashSlot, (double)event.getMouseX(), (double)event.getMouseY())) {
                    if (screen.method_17577().method_34255().method_7960() && trashSlot.method_7681()) {
                        event.getGuiGraphics().method_51446(class_310.method_1551().field_1772, trashSlot.method_7677(), event.getMouseX(), event.getMouseY());
                    } else if (TrashSlotConfig.getActive().instantDeletion) {
                        event.getGuiGraphics().method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"tooltip.trashslot.destroy_item"), event.getMouseX(), event.getMouseY());
                    } else {
                        event.getGuiGraphics().method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"tooltip.trashslot.trash_item"), event.getMouseX(), event.getMouseY());
                    }
                }
            }
        }
        if (currentHint != null) {
            currentHint.render(event.getScreen(), event.getGuiGraphics());
            if (currentHint.isComplete()) {
                TrashSlotSaveState.getInstance().markHintAsSeen(currentHint.getId());
                TrashSlotSaveState.save();
                currentHint = null;
            }
        }
    }

    public static TrashSlotComponent getTrashSlotComponent() {
        return trashSlotComponent;
    }

    public static TrashSlotSlot getTrashSlot() {
        return trashSlot;
    }

    public static boolean isLeftMouseDown() {
        return isLeftMouseDown;
    }

    static {
        currentContainerSettings = ContainerSettings.NONE;
    }
}

