/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codecs.YRangeAllowance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3542;
import net.minecraft.class_3785;
import net.minecraft.class_5434;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_9822;
import org.joml.Vector3f;

public class StrongholdEndStructure
extends GenericJigsawStructure {
    public static final MapCodec<StrongholdEndStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StrongholdEndStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)class_2960.field_25139.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)class_3542.method_28140(GenericJigsawStructure.BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, StrongholdEndStructure::new));

    public StrongholdEndStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<YRangeAllowance> yAllowance, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<class_2960> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, boolean useBoundingBoxHack, class_9822 liquidSettings) {
        super(config, startPool, size, yAllowance, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, buryingType, useBoundingBoxHack, liquidSettings);
    }

    @Override
    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        boolean superCheck = super.extraSpawningChecks(context, blockPos);
        if (!superCheck) {
            return false;
        }
        class_1923 chunkPos = context.comp_568();
        int minLandHeight = Math.min(GeneralUtils.getMaxTerrainLimit(context.comp_562()), context.comp_562().method_33730() + 45);
        int xPos = chunkPos.method_8326();
        int zPos = chunkPos.method_8328();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                Vector3f offsetPos = direction.method_23955();
                offsetPos.mul(35.0f * (float)i);
                landHeight = StrongholdEndStructure.getHeightAt(context, xPos + (int)offsetPos.x(), zPos + (int)offsetPos.z(), landHeight);
                if (landHeight >= minLandHeight) continue;
                return false;
            }
        }
        return (landHeight = StrongholdEndStructure.getHeightAt(context, xPos, zPos, landHeight)) >= minLandHeight;
    }

    private static int getHeightAt(class_3195.class_7149 context, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, GeneralUtils.getCachedFreeHeight(context.comp_562(), xPos, zPos, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564())) - 1;
        return landHeight;
    }

    @Override
    public class_7151<?> method_41618() {
        return RSStructures.STRONGHOLD_END.get();
    }
}

