/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixins.structures.JigsawJunctionAccessor;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3748;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5000;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import net.minecraft.server.MinecraftServer;

public final class GeneralUtils {
    private static final Map<class_2680, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<class_2680, Boolean>();
    private static final ConcurrentHashMap<HeightKey, Integer> CACHED_HEIGHT = new ConcurrentHashMap(2048);

    private GeneralUtils() {
    }

    public static <T> T loadService(Class<T> service) {
        return ServiceLoader.load(service).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + service.getName()));
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, class_5819 random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.method_43057() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(class_2680 state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> class_2248.method_9614((class_265)stateIn.method_26201()));
    }

    public static class_2680 orientateChest(class_5425 blockView, class_2338 blockPos, class_2680 blockState) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 wallDirection = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)blockPos).method_10098(facing);
            if (!GeneralUtils.isFullCube(blockView.method_8320((class_2338)mutable))) continue;
            wallDirection = facing;
            mutable.method_10104(facing.method_10153(), 2);
            if (blockView.method_8320((class_2338)mutable).method_51367()) continue;
            break;
        }
        return (class_2680)blockState.method_11657((class_2769)class_2383.field_11177, (Comparable)wallDirection.method_10153());
    }

    public static class_1799 enchantRandomly(class_5455 registryAccess, class_5819 random, class_1799 itemToEnchant, float chance) {
        List<class_6880.class_6883> list;
        if (random.method_43057() < chance && !(list = registryAccess.method_30530(class_7924.field_41265).method_42017().filter(holder -> ((class_1887)holder.comp_349()).method_8192(itemToEnchant) && holder.method_40220(class_9636.field_51548)).toList()).isEmpty()) {
            class_6880.class_6883 enchantment = list.get(random.method_43048(list.size()));
            int enchantmentLevel = random.method_43048(class_3532.method_15395((class_5819)random, (int)((class_1887)enchantment.comp_349()).method_8187(), (int)((class_1887)enchantment.comp_349()).method_8183()) + 1);
            itemToEnchant.method_7978((class_6880)enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(class_2794 chunkGenerator) {
        return chunkGenerator.method_33730() + chunkGenerator.method_12104();
    }

    public static class_2338 getHighestLand(class_2794 chunkGenerator, class_7138 randomState, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        while (mutable.method_10264() > chunkGenerator.method_16398()) {
            class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
            if (!currentBlockstate.method_26225()) {
                mutable.method_10098(class_2350.field_11033);
                continue;
            }
            if (blockView.method_32892(mutable.method_10264() + 3).method_26215() && (canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225())) {
                return mutable;
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return mutable;
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_7138 randomState, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), chunkGenerator.method_16398() + 1, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
        while (mutable.method_10264() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40) {
            if ((canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225()) && blockView.method_32892(mutable.method_10264() + 1).method_26215() && blockView.method_32892(mutable.method_10264() + 5).method_26215()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            currentBlockstate = blockView.method_32892(mutable.method_10264());
        }
        return mutable.method_10103(mutable.method_10263(), chunkGenerator.method_16398(), mutable.method_10260());
    }

    public static int getFirstLandYFromPos(class_4538 worldView, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10101((class_2382)pos);
        class_2791 currentChunk = worldView.method_22350((class_2338)mutable);
        class_2680 currentState = currentChunk.method_8320((class_2338)mutable);
        while (mutable.method_10264() >= worldView.method_31607() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.method_10098(class_2350.field_11033);
            currentState = currentChunk.method_8320((class_2338)mutable);
        }
        return mutable.method_10264();
    }

    private static boolean isReplaceableByStructures(class_2680 blockState) {
        return blockState.method_26215() || !blockState.method_26227().method_15769() || blockState.method_26164(class_3481.field_44470);
    }

    public static void centerAllPieces(class_2338 targetPos, List<? extends class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(xOffset, 0, zOffset);
        }
    }

    public static void movePieceProperly(class_3443 piece, int x, int y, int z) {
        piece.method_14922(x, y, z);
        if (piece instanceof class_3790) {
            class_3790 poolElementStructurePiece = (class_3790)piece;
            poolElementStructurePiece.method_16645().forEach(junction -> {
                ((JigsawJunctionAccessor)junction).repurposedstructures$setSourceX(junction.method_16610() + x);
                ((JigsawJunctionAccessor)junction).repurposedstructures$setSourceGroundY(junction.method_16611() + y);
                ((JigsawJunctionAccessor)junction).repurposedstructures$setSourceZ(junction.method_16609() + z);
            });
        }
    }

    public static boolean canJigsawsAttach(class_3499.class_10326 jigsaw1, class_3499.class_10326 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.comp_3278().comp_1342().method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.comp_3278().comp_1342().method_11654((class_2769)class_3748.field_23262);
        return prop1.method_26426() == prop2.method_26426().method_10153() && (prop1.method_26428() == prop2.method_26428() || GeneralUtils.isRollableJoint(jigsaw1, prop1)) && jigsaw1.comp_3278().comp_1343().method_68564("target", "").equals(jigsaw2.comp_3278().comp_1343().method_68564("name", ""));
    }

    private static boolean isRollableJoint(class_3499.class_10326 jigsaw1, class_5000 prop1) {
        String joint = jigsaw1.comp_3278().comp_1343().method_68564("joint", "");
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.method_26426().method_10166().method_10179();
        }
        return joint.equals("rollable");
    }

    public static Map<class_2960, JsonElement> getDatapacksJSONElement(class_3300 resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<class_2960, JsonElement> map = new HashMap<class_2960, JsonElement>();
        int dataTypeLength = dataType.length() + 1;
        for (Map.Entry resourceStackEntry : resourceManager.method_14488(dataType, fileString -> true).entrySet()) {
            String identifierPath = ((class_2960)resourceStackEntry.getKey()).method_12832();
            class_2960 fileID = class_2960.method_60655((String)((class_2960)resourceStackEntry.getKey()).method_12836(), (String)identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                InputStream fileStream = ((class_3298)resourceStackEntry.getValue()).method_14482();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                    JsonElement countsJSONElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                    map.put(fileID, countsJSONElement);
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, resourceStackEntry, (Object)exception);
            }
        }
        return map;
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<class_5321<class_52>, class_5321<class_52>> entry) {
        boolean invalidLootTableFound = false;
        class_7871 lootTableRegistry = minecraftServer.method_58576().method_58294().method_46751(class_7924.field_50079);
        if (lootTableRegistry.method_46746(entry.getKey()).isEmpty()) {
            RepurposedStructures.LOGGER.error("Unable to find loot table key: {}", entry.getKey());
            invalidLootTableFound = true;
        }
        if (lootTableRegistry.method_46746(entry.getValue()).isEmpty()) {
            RepurposedStructures.LOGGER.error("Unable to find loot table value: {}", entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }

    public static boolean isMissingLootImporting(MinecraftServer minecraftServer, Set<class_5321<class_52>> tableKeys) {
        AtomicBoolean invalidLootTableFound = new AtomicBoolean(false);
        class_2378 lootTableRegistry = (class_2378)minecraftServer.method_58576().method_58294().method_46751(class_7924.field_50079);
        lootTableRegistry.method_10235().forEach(rl -> {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)rl);
            if (rl.method_12836().equals("repurposed_structures") && !tableKeys.contains(key)) {
                if (rl.method_12832().contains("mansions") && rl.method_12832().contains("storage")) {
                    return;
                }
                if (rl.method_12832().contains("monuments")) {
                    return;
                }
                if (rl.method_12832().contains("dispensers/temples/wasteland_lava")) {
                    return;
                }
                if (rl.method_12832().contains("lucky_pool")) {
                    return;
                }
                if (rl.method_12832().contains("archaeology")) {
                    return;
                }
                RepurposedStructures.LOGGER.error("No loot importing found for: {}", rl);
                invalidLootTableFound.set(true);
            }
        });
        return invalidLootTableFound.get();
    }

    public static boolean nameMatch(String biomeName, String ... targetMatch) {
        return Arrays.stream(targetMatch).anyMatch(biomeName::contains);
    }

    public static boolean nameExactMatch(String biomeName, String ... targetMatch) {
        return Arrays.asList(targetMatch).contains(biomeName);
    }

    public static class_2680 copyBlockProperties(class_2680 oldBlockState, class_2680 newBlockState) {
        for (class_2769 property : oldBlockState.method_28501()) {
            if (!newBlockState.method_28498(property)) continue;
            newBlockState = GeneralUtils.getStateWithProperty(newBlockState, oldBlockState, property);
        }
        return newBlockState;
    }

    public static <T extends Comparable<T>> class_2680 getStateWithProperty(class_2680 state, class_2680 stateToCopy, class_2769<T> property) {
        return (class_2680)state.method_11657(property, stateToCopy.method_11654(property));
    }

    public static List<class_3449> inboundsValidStartsForAllStructure(class_3233 level, class_2338 position, Predicate<class_3195> structureMatch) {
        class_5138 structureManager = level.method_8410().method_27056();
        class_4076 sectionPos = class_4076.method_18682((class_2338)position);
        class_2791 chunkAccess = level.method_22342(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16422);
        if (!chunkAccess.method_51526().method_12165(class_2806.field_16422)) {
            return new ArrayList<class_3449>();
        }
        Map references = chunkAccess.method_12179();
        ArrayList<class_3449> list = new ArrayList<class_3449>();
        for (Map.Entry entry : references.entrySet()) {
            if (!structureMatch.test((class_3195)entry.getKey())) continue;
            GeneralUtils.fillStartsForStructure((class_4538)level, structureManager, (class_3195)entry.getKey(), (LongSet)entry.getValue(), position, list::add);
        }
        return list;
    }

    public static void fillStartsForStructure(class_4538 level, class_5138 structureManager, class_3195 structure, LongSet references, class_2338 position, Consumer<class_3449> consumer) {
        LongIterator longIterator = references.iterator();
        while (longIterator.hasNext()) {
            class_3449 structureStart;
            long ref = (Long)longIterator.next();
            class_4076 sectionPos = class_4076.method_18681((class_1923)new class_1923(ref), (int)level.method_31607());
            if (!level.method_8393(sectionPos.method_18674(), sectionPos.method_18687()) || (structureStart = structureManager.method_26975(sectionPos, structure, (class_2810)level.method_22342(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16423))) == null || !structureStart.method_16657() || !structureStart.method_14969().method_14662((class_2382)position)) continue;
            consumer.accept(structureStart);
        }
    }

    public static int getCachedFreeHeight(class_2794 chunkGenerator, int x, int z, class_2902.class_2903 types, class_5539 levelHeightAccessor, class_7138 randomState) {
        HeightKey key = new HeightKey(chunkGenerator, x, z);
        Integer y = CACHED_HEIGHT.get(key);
        if (y == null) {
            if (CACHED_HEIGHT.size() >= 2048) {
                CACHED_HEIGHT.clear();
            }
            y = chunkGenerator.method_20402(x, z, types, levelHeightAccessor, randomState);
            CACHED_HEIGHT.put(key, y);
        }
        return y;
    }

    private record HeightKey(class_2794 chunkGenerator, int x, int z) {
    }
}

