/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.google.common.collect.ImmutableList;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.events.RegisterVillagerTradesEvent;
import com.telepathicgrunt.repurposedstructures.events.RegisterWanderingTradesEvent;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.RegisterReloadListenerEvent;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.ServerGoingToStartEvent;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.ServerGoingToStopEvent;
import com.telepathicgrunt.repurposedstructures.misc.FabricReloadListener;
import com.telepathicgrunt.repurposedstructures.mixins.entities.VillagerTradesAccessor;
import com.telepathicgrunt.repurposedstructures.world.biomemodifiers.BiomeModifier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class RepurposedStructuresFabric
implements ModInitializer {
    public void onInitialize() {
        RSModdedLootConfig.setup();
        RepurposedStructures.init();
        BiomeModifier.addFeatures();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ServerGoingToStartEvent.EVENT.invoke(new ServerGoingToStartEvent(server));
            RepurposedStructuresFabric.setupWanderingTrades();
            RepurposedStructuresFabric.setupVillagerTrades();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ServerGoingToStopEvent.EVENT.invoke(ServerGoingToStopEvent.INSTANCE));
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener((class_2960)id, (class_3302)listener))));
    }

    private static void setupWanderingTrades() {
        List trades = class_3853.field_17724;
        List buying = Arrays.stream((class_3853.class_1652[])((Pair)trades.get(0)).getKey()).collect(Collectors.toCollection(ArrayList::new));
        List rare = Arrays.stream((class_3853.class_1652[])((Pair)trades.get(1)).getKey()).collect(Collectors.toCollection(ArrayList::new));
        List basic = Arrays.stream((class_3853.class_1652[])((Pair)trades.get(2)).getKey()).collect(Collectors.toCollection(ArrayList::new));
        RegisterWanderingTradesEvent.EVENT.invoke(new RegisterWanderingTradesEvent(basic::add, rare::add, buying::add));
        VillagerTradesAccessor.setWANDERING_TRADER_TRADES((List<Pair<class_3853.class_1652[], Integer>>)ImmutableList.builder().add((Object[])new Pair[]{Pair.of((Object)((class_3853.class_1652[])buying.toArray(class_3853.class_1652[]::new)), (Object)((Integer)((Pair)trades.get(0)).getValue())), Pair.of((Object)((class_3853.class_1652[])rare.toArray(class_3853.class_1652[]::new)), (Object)((Integer)((Pair)trades.get(1)).getValue())), Pair.of((Object)((class_3853.class_1652[])basic.toArray(class_3853.class_1652[]::new)), (Object)((Integer)((Pair)trades.get(2)).getValue()))}).build());
    }

    private static void setupVillagerTrades() {
        Map trades = class_3853.field_17067;
        for (class_5321 profession : class_7923.field_41195.method_42021()) {
            int i;
            if (profession == null) continue;
            Int2ObjectMap profTrades = trades.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap listings = new Int2ObjectOpenHashMap();
            for (i = 1; i <= 5; ++i) {
                if (profTrades.containsKey(i)) {
                    List list = Arrays.stream((class_3853.class_1652[])profTrades.get(i)).collect(Collectors.toList());
                    listings.put(i, list);
                    continue;
                }
                listings.put(i, new ArrayList());
            }
            RegisterVillagerTradesEvent.EVENT.invoke(new RegisterVillagerTradesEvent((class_5321<class_3852>)profession, (arg_0, arg_1) -> RepurposedStructuresFabric.lambda$setupVillagerTrades$7((Int2ObjectMap)listings, arg_0, arg_1)));
            for (i = 1; i <= 5; ++i) {
                profTrades.put(i, (Object)((List)listings.get(i)).toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private static /* synthetic */ void lambda$setupVillagerTrades$7(Int2ObjectMap listings, Integer i, class_3853.class_1652 listing) {
        ((List)listings.get(i.intValue())).add(listing);
    }
}

