/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.entity.npc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.network.ClientboundBuildOffersMessage;
import fuzs.tradingpost.network.ClientboundMerchantDataMessage;
import fuzs.tradingpost.network.ClientboundRemoveMerchantsMessage;
import fuzs.tradingpost.world.entity.npc.LocalMerchant;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3851;
import net.minecraft.class_3914;
import net.minecraft.class_9306;
import org.jetbrains.annotations.Nullable;

public class MerchantCollection
implements class_1915 {
    private final Int2ObjectOpenHashMap<class_1915> idToMerchant = new Int2ObjectOpenHashMap();
    private final Set<class_1914> disabledOffers = Sets.newHashSet();
    private final class_3914 access;
    private class_1916 allOffers = new class_1916();
    private Object2ObjectOpenHashMap<class_1914, class_1915> offerToMerchant;
    private class_1915 currentMerchant;

    public MerchantCollection() {
        this(class_3914.field_17304);
    }

    public MerchantCollection(class_3914 access) {
        this.access = access;
    }

    public void addMerchant(int entityId, class_1915 merchant) {
        if (!merchant.method_8264().isEmpty()) {
            this.idToMerchant.put(entityId, (Object)merchant);
        }
    }

    @Nullable
    public class_1657 method_8257() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.method_8257();
        }
        return null;
    }

    public void method_8259(@Nullable class_1657 player) {
        this.idToMerchant.values().forEach(merchant -> merchant.method_8259(player));
    }

    public class_1916 method_8264() {
        return this.allOffers;
    }

    public boolean checkOffer(class_1914 offer) {
        return !this.disabledOffers.contains(offer);
    }

    public void method_8261(@Nullable class_1916 p_213703_1_) {
        TradingPost.LOGGER.error("Set offers to stored merchants directly");
    }

    public void method_8262(class_1914 offer) {
        if (this.currentMerchant != null) {
            this.currentMerchant.method_8262(offer);
            if (!((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).teleportXp) {
                return;
            }
            this.access.method_17393((level, pos) -> {
                class_1915 patt0$temp = this.currentMerchant;
                if (patt0$temp instanceof class_1297) {
                    class_1297 entity = (class_1297)patt0$temp;
                    class_243 merchantPos = entity.method_19538().method_1031(0.0, 0.5, 0.0);
                    double xpWidth = 0.5;
                    double xpHeight = 0.5;
                    List xpRewards = level.method_8390(class_1303.class, new class_238(merchantPos.method_1031(-0.5, -0.5, -0.5), merchantPos.method_1031(0.5, 0.5, 0.5)), class_1297::method_5805);
                    for (class_1303 xpOrb : xpRewards) {
                        level.method_8649((class_1297)new class_1303(level, (double)pos.method_10263(), (double)pos.method_10264() + 1.5, (double)pos.method_10260(), xpOrb.method_5919()));
                        xpOrb.method_31472();
                    }
                }
            });
        }
    }

    public void method_8258(class_1799 stack) {
        if (this.currentMerchant != null) {
            this.currentMerchant.method_8258(stack);
        }
    }

    public boolean method_38069() {
        return this.access == class_3914.field_17304;
    }

    public boolean method_65125(class_1657 player) {
        return true;
    }

    public int method_19269() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.method_19269();
        }
        return 0;
    }

    public class_1915 getCurrentMerchant() {
        return this.currentMerchant;
    }

    public boolean method_20708() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.method_20708();
        }
        return false;
    }

    public void method_19271(int xpValue) {
        if (this.currentMerchant != null) {
            this.currentMerchant.method_19271(xpValue);
        }
    }

    public boolean method_19270() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.method_19270();
        }
        return false;
    }

    public class_3414 method_18010() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.method_18010();
        }
        return class_3417.field_14815;
    }

    public int getTraderLevel() {
        if (this.currentMerchant != null) {
            class_1915 merchant = this.currentMerchant;
            if (merchant instanceof LocalMerchant) {
                return ((LocalMerchant)merchant).getMerchantLevel();
            }
            if (merchant instanceof class_3851) {
                return ((class_3851)merchant).method_7231().comp_3522();
            }
        }
        return 0;
    }

    @Nullable
    public class_2561 getDisplayName() {
        if (this.currentMerchant != null) {
            class_1915 merchant = this.currentMerchant;
            if (merchant instanceof LocalMerchant) {
                return ((LocalMerchant)merchant).getDisplayName();
            }
            if (merchant instanceof class_1297) {
                return ((class_1297)merchant).method_5476();
            }
        }
        return null;
    }

    public boolean updateAvailableMerchants(class_3222 serverPlayer, int containerId, class_2338 pos, boolean testRange) {
        IntOpenHashSet toRemove = new IntOpenHashSet();
        for (Map.Entry entry : this.idToMerchant.int2ObjectEntrySet()) {
            if (!(entry.getValue() instanceof class_1297) || ((class_1915)entry.getValue()).method_8257() == serverPlayer && (!testRange || this.traderInRange((class_1297)entry.getValue(), pos))) continue;
            toRemove.add(((Integer)entry.getKey()).intValue());
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this::removeMerchant);
            MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((class_3222)serverPlayer), (Message)new ClientboundRemoveMerchantsMessage(containerId, (IntSet)toRemove));
        }
        return !this.idToMerchant.isEmpty();
    }

    private boolean traderInRange(class_1297 entity, class_2338 pos) {
        return this.traderInRange(entity, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    private boolean traderInRange(class_1297 entity, double posX, double posY, double posZ) {
        return Math.abs(entity.method_23317() - posX) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange && Math.abs(entity.method_23318() - posY) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).verticalRange && Math.abs(entity.method_23321() - posZ) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange;
    }

    public void removeMerchant(int merchantId) {
        class_1915 merchant = (class_1915)this.idToMerchant.get(merchantId);
        if (merchant != null) {
            this.disabledOffers.addAll((Collection<class_1914>)merchant.method_8264());
            this.idToMerchant.remove(merchantId);
            merchant.method_8259(null);
            if (this.currentMerchant == merchant) {
                this.currentMerchant = null;
            }
        }
    }

    public void setActiveOffer(class_1914 offer) {
        if (this.offerToMerchant != null) {
            this.currentMerchant = offer != null ? (class_1915)this.offerToMerchant.get((Object)offer) : null;
        }
    }

    public void sendMerchantData(class_3222 serverPlayer, int containerId) {
        for (Map.Entry entry : this.idToMerchant.int2ObjectEntrySet()) {
            int n;
            class_2561 merchantTitle;
            class_1915 merchant = (class_1915)entry.getValue();
            class_2561 class_25612 = merchantTitle = merchant instanceof class_1297 ? ((class_1297)merchant).method_5476() : TradingPostBlockEntity.CONTAINER_COMPONENT;
            if (merchant instanceof class_3851) {
                class_3851 villagerDataHolder = (class_3851)merchant;
                n = villagerDataHolder.method_7231().comp_3522();
            } else {
                n = 0;
            }
            int merchantLevel = n;
            ClientboundMerchantDataMessage message = new ClientboundMerchantDataMessage(containerId, (Integer)entry.getKey(), merchantTitle, merchant.method_8264(), merchantLevel, merchant.method_19269(), merchant.method_19270(), merchant.method_20708());
            MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((class_3222)serverPlayer), (Message)message);
        }
        MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((class_3222)serverPlayer), (Message)new ClientboundBuildOffersMessage(containerId, this.getIdToOfferCountMap()));
    }

    public Int2IntOpenHashMap getIdToOfferCountMap() {
        return this.idToMerchant.int2ObjectEntrySet().stream().collect(Collectors.toMap(Int2ObjectMap.Entry::getIntKey, entry -> ((class_1915)entry.getValue()).method_8264().size(), (o1, o2) -> o1, Int2IntOpenHashMap::new));
    }

    public void buildOffers(Int2IntOpenHashMap idToOfferCount) {
        ArrayList sortedEntries = Lists.newArrayList((Iterable)idToOfferCount.int2IntEntrySet());
        sortedEntries.sort(Comparator.comparingInt(Int2IntMap.Entry::getIntKey));
        TradingPostOffers allOffers = new TradingPostOffers(this.disabledOffers);
        for (Int2IntMap.Entry entry : sortedEntries) {
            class_1915 merchant = (class_1915)this.idToMerchant.get(entry.getIntKey());
            for (int i = 0; i < entry.getIntValue(); ++i) {
                class_1914 offer;
                if (merchant != null && i < merchant.method_8264().size()) {
                    offer = (class_1914)merchant.method_8264().get(i);
                } else {
                    offer = MerchantCollection.fakeOffer();
                    this.disabledOffers.add(offer);
                }
                allOffers.add(offer);
            }
        }
        this.allOffers = allOffers;
        this.buildOfferToMerchantMap();
    }

    private void buildOfferToMerchantMap() {
        Object2ObjectOpenHashMap offerToMerchant = new Object2ObjectOpenHashMap();
        for (class_1915 merchant : this.idToMerchant.values()) {
            merchant.method_8264().forEach(offer -> offerToMerchant.put(offer, (Object)merchant));
        }
        this.offerToMerchant = offerToMerchant;
    }

    private static class_1914 fakeOffer() {
        return new class_1914(new class_9306((class_1935)class_1802.field_8162), class_1799.field_8037, -1, -1, 0.0f);
    }
}

