/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion;

import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.handler.VillagerGoalHandler;
import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.init.ModEnumConstants;
import fuzs.illagerinvasion.init.ModLootTables;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import net.minecraft.class_1299;
import net.minecraft.class_1588;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3732;
import net.minecraft.class_5134;
import net.minecraft.class_9169;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IllagerInvasion
implements ModConstructor {
    public static final String MOD_ID = "illagerinvasion";
    public static final String MOD_NAME = "Illager Invasion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Illager Invasion");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"illagerinvasion").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        IllagerInvasion.registerEventHandlers();
    }

    public void onCommonSetup() {
        ModEnumConstants.bootstrap();
        VillagerGoalHandler.init();
    }

    private static void registerEventHandlers() {
        ServerEntityLevelEvents.LOAD.register(VillagerGoalHandler::onEntityLoad);
        LootTableLoadCallback.EVENT.register(ModLootTables::onLootTableLoad);
        RegisterPotionBrewingMixesCallback.EVENT.register(IllagerInvasion::registerPotionRecipes);
    }

    private static void registerPotionRecipes(RegisterPotionBrewingMixesCallback.Builder builder) {
        builder.registerPotionRecipe(class_1847.field_8999, class_1802.field_39057, ModRegistry.BERSERKING_POTION);
        builder.registerPotionRecipe(ModRegistry.BERSERKING_POTION, class_1802.field_8725, ModRegistry.LONG_BERSERKING_POTION);
        builder.registerPotionRecipe(ModRegistry.BERSERKING_POTION, class_1802.field_8601, ModRegistry.STRONG_BERSERKING_POTION);
    }

    public void onRegisterEntityAttributes(EntityAttributesContext context) {
        context.registerAttributes((class_1299)ModEntityTypes.ALCHEMIST_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.38));
        context.registerAttributes((class_1299)ModEntityTypes.ARCHIVIST_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.36));
        context.registerAttributes((class_1299)ModEntityTypes.BASHER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.31).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23722, 0.2));
        context.registerAttributes((class_1299)ModEntityTypes.FIRECALLER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
        context.registerAttributes((class_1299)ModEntityTypes.INQUISITOR_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.33).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23722, 1.6).method_26868(class_5134.field_23718, 0.8));
        context.registerAttributes((class_1299)ModEntityTypes.INVOKER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23719, 0.36).method_26868(class_5134.field_23718, 0.3).method_26868(class_5134.field_23721, 8.0));
        context.registerAttributes((class_1299)ModEntityTypes.MARAUDER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.3));
        context.registerAttributes((class_1299)ModEntityTypes.PROVOKER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.38));
        context.registerAttributes((class_1299)ModEntityTypes.SORCERER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
        context.registerAttributes((class_1299)ModEntityTypes.SURRENDERED_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23721, 5.0));
        context.registerAttributes((class_1299)ModEntityTypes.NECROMANCER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModEntityTypes.ALCHEMIST_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.ARCHIVIST_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.BASHER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.FIRECALLER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.INQUISITOR_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.INVOKER_ENTITY_TYPE.comp_349(), class_9169.field_48742, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MARAUDER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.PROVOKER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.SORCERER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.SURRENDERED_ENTITY_TYPE.comp_349(), class_9169.field_48742, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.NECROMANCER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

