/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.item.BucketItemAccessor;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3713;
import net.minecraft.class_3718;
import net.minecraft.class_3962;
import net.minecraft.class_5819;
import net.minecraft.class_7689;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnUtil {
    public static void spawnSparks(class_1937 level, class_5819 random, class_2338 pos, SparkType sparkType, Box box, class_243 maxSpeeds, int count, List<Integer> colors) {
        if (random.method_43056()) {
            class_243 start = box.min();
            class_243 end = box.max();
            for (int i = 0; i < count; ++i) {
                level.method_8406((class_2394)SparkParticle.create(sparkType, random, colors), (double)pos.method_10263() + class_3532.method_15366((class_5819)random, (double)start.field_1352, (double)end.field_1352), (double)pos.method_10264() + class_3532.method_15366((class_5819)random, (double)start.field_1351, (double)end.field_1351), (double)pos.method_10260() + class_3532.method_15366((class_5819)random, (double)start.field_1350, (double)end.field_1350), MathUtil.nextNonAbsDouble(random, maxSpeeds.method_10216()), MathUtil.nextNonAbsDouble(random, maxSpeeds.method_10214()), MathUtil.nextNonAbsDouble(random, maxSpeeds.method_10215()));
            }
        }
    }

    public static void spawnParticlesAroundBlock(class_2394 particle, class_1937 level, class_2338 pos, class_5819 random, int perSideChance) {
        ParticleSpawnUtil.spawnParticlesAroundBlock(particle, level, pos, random, 0.0625f, perSideChance > 0 ? direction -> random.method_43048(perSideChance) != 0 : null);
    }

    public static void spawnParticlesAroundBlock(class_2394 particle, class_1937 level, class_2338 pos, class_5819 random, float offset, @Nullable Predicate<class_2350> predicate) {
        for (class_2350 direction : class_2350.values()) {
            if (predicate != null && predicate.test(direction)) {
                return;
            }
            class_2338 relativePos = pos.method_10093(direction);
            if (level.method_8320(relativePos).method_26216()) continue;
            ParticleSpawnUtil.spawnParticlesOnSide(particle, offset, direction, level, pos, random, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesOnSide(class_2394 particle, float offset, class_2350 direction, class_1937 level, class_2338 pos, class_5819 random, double xSpeed, double ySpeed, double zSpeed) {
        double offsetFromCenter = 0.5 + (double)offset;
        class_2350.class_2351 axis = direction.method_10166();
        double xOffset = axis == class_2350.class_2351.field_11048 ? 0.5 + offsetFromCenter * (double)direction.method_10148() : (double)random.method_43057();
        double yOffset = axis == class_2350.class_2351.field_11052 ? 0.5 + offsetFromCenter * (double)direction.method_10164() : (double)random.method_43057();
        double zOffset = axis == class_2350.class_2351.field_11051 ? 0.5 + offsetFromCenter * (double)direction.method_10165() : (double)random.method_43057();
        level.method_8406(particle, (double)pos.method_10263() + xOffset, (double)pos.method_10264() + yOffset, (double)pos.method_10260() + zOffset, xSpeed, ySpeed, zSpeed);
    }

    public static void spawnFallDustClouds(class_1297 entity, float distance, int fallDamage, ClientBoundEntityFellPayload.TypeConfig config) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 && entity.equals((Object)class_310.method_1551().field_1724)) {
            ParticleSpawnUtil.spawnEntityFellParticles((class_1309)entity, entity.method_23318(), distance, fallDamage, ModConfigs.ENTITIES.dustClouds.playerFell);
        } else if (level instanceof class_3218) {
            class_3222 player;
            class_3218 serverLevel = (class_3218)level;
            Services.NETWORK.sendToClientsTracking(entity instanceof class_3222 ? (player = (class_3222)entity) : null, serverLevel, entity.method_24515(), new ClientBoundEntityFellPayload(entity.method_5628(), entity.method_23318(), distance, fallDamage, config));
        }
    }

    public static void spawnCreatureMovementDustClouds(class_1309 entity, class_1937 level, class_5819 random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.mobRunning) {
            ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig(entity, level, random, YSpeedModifier);
        }
    }

    public static void spawnCreatureMovementDustCloudsNoConfig(class_1309 entity, class_1937 level, class_5819 random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.method_8520(entity.method_24515())) {
            return;
        }
        if (entity.method_5767()) {
            return;
        }
        level.method_8406((class_2394)ModParticles.LARGE_DUST_CLOUD.get(), entity.method_19538().field_1352 + (double)entity.method_17681() * random.method_43058() - 1.0, entity.method_23318() + Math.max(Math.min((double)random.method_43057(), 0.5), 0.2), entity.method_19538().field_1350 + (double)entity.method_17681() * random.method_43058() - 1.0, 0.0, random.method_43058() * (double)YSpeedModifier, 0.0);
    }

    public static void spawnCmdBlockParticles(class_1937 level, class_243 pos, class_5819 random, BiPredicate<class_2350, class_243> directionValidator) {
        for (class_2350 direction : class_2350.values()) {
            class_243 endPos = pos.method_43206(direction, 1.0);
            class_243 relativePos = endPos.method_43206(direction, -0.5);
            if (!directionValidator.test(direction, endPos)) continue;
            class_243 speed = pos.method_1035(relativePos).method_49272(random, 1.0f);
            level.method_8406((class_2394)new DirectionParticleOptions(ModParticles.COMMAND_BLOCK.get(), direction), endPos.method_10216(), endPos.method_10214(), endPos.method_10215(), speed.method_10216(), speed.method_10214(), speed.method_10215());
        }
    }

    public static void spawnHeatedWaterParticles(class_1937 level, class_2338 pos, class_5819 random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig) {
        int brightness = level.method_8314(class_1944.field_9282, pos);
        height -= 0.1;
        switch (ModConfigs.BLOCKS.steam.spawnLogic) {
            case NEAR_LAVA: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            if (!level.method_8316(pos.method_10069(x, y, z)).method_15767(class_3486.field_15518)) continue;
                            ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
                        }
                    }
                }
                break;
            }
            case BRIGHTNESS: {
                if (brightness <= (Integer)ModConfigs.BLOCKS.steam.steamingThreshold.get() && !level.method_8320(pos.method_10074()).method_27852(class_2246.field_10092)) break;
                ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
            }
        }
    }

    private static void spawnHeatedWaterParticles(class_1937 level, class_2338 pos, class_5819 random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig, int brightness) {
        if (steamConfig && !isFalling && !Util.isSolidOrNotEmpty(level, pos.method_10084())) {
            level.method_8406((class_2394)ModParticles.STEAM.get(), (double)pos.method_10263() + random.method_43058(), (double)pos.method_10264() + 0.875 + MathUtil.nextDouble(random, 0.5), (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
        }
        if (boilingConfig && brightness >= (Integer)ModConfigs.BLOCKS.steam.boilingThreshold.get()) {
            level.method_8406((class_2394)class_2398.field_11247, (double)pos.method_10263() + random.method_43058(), class_3532.method_15350((double)random.method_43058(), (double)pos.method_10264(), (double)((double)pos.method_10264() + height)), (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnEntityFellParticles(class_1309 entity, double y, float distance, int fallDamage, boolean config) {
        if (!config || entity.method_5864().method_20210(class_3483.field_42971)) {
            return;
        }
        if (entity.method_5767()) {
            return;
        }
        if (!(fallDamage > 0 || entity instanceof class_1496 && (double)distance > (entity instanceof class_7689 ? 0.5 : 1.0))) {
            return;
        }
        if (entity.method_5799() || entity.method_5771() || entity.field_27857) {
            return;
        }
        class_1937 level = entity.method_37908();
        class_5819 random = entity.method_59922();
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.method_8520(entity.method_24515())) {
            return;
        }
        if (!level.method_8316(entity.method_23312().method_33096(class_3532.method_15357((double)y))).method_15769()) {
            return;
        }
        if (fallDamage < 4) {
            for (int i = 0; i < 5; ++i) {
                level.method_8406((class_2394)ModParticles.SMALL_DUST_CLOUD.get(), entity.method_23322(1.0), y + Math.max(Math.min((double)random.method_43057(), 0.5), 0.2), entity.method_23325(1.0), 0.3 * (double)MathUtil.nextSign(random), random.method_43058(), 0.3 * (double)MathUtil.nextSign(random));
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            level.method_8406((class_2394)ModParticles.LARGE_DUST_CLOUD.get(), entity.method_23322(1.0), y + Math.max(Math.min((double)random.method_43057(), 0.5), 0.2), entity.method_23325(1.0), 0.5 * (double)MathUtil.nextSign(random), random.method_43058() * 3.0, 0.5 * (double)MathUtil.nextSign(random));
        }
    }

    public static void spawnEntityFaceParticle(class_2394 options, class_1309 entity, class_1937 level, class_5819 random, class_243 offset, float partialTick) {
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, random, new class_243(((double)random.method_43057() - 0.5) * 0.3, (double)(-random.method_43057()) * 0.6 - 0.3, 0.6).method_1019(offset), new class_243(((double)random.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1 + 0.05, 0.0), partialTick);
    }

    public static void spawnEntityFaceParticle(class_2394 options, class_1309 entity, class_1937 level, class_5819 random, class_243 offset, class_243 speed, float partialTick) {
        speed = speed.method_1037(-entity.method_5695(partialTick) * ((float)Math.PI / 180));
        speed = speed.method_1024(-entity.method_5705(partialTick) * ((float)Math.PI / 180));
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, offset, speed, partialTick);
    }

    public static void spawnEntityFaceParticle(class_2394 options, class_1309 entity, class_1937 level, class_243 offset, class_243 speed, float partialTick) {
        ParticleSpawnUtil.spawnEntityHeadParticle(options, entity, level, offset.method_1031(0.0, 0.0, 0.6), speed, partialTick);
    }

    public static void spawnEntityHeadParticle(class_2394 options, class_1309 entity, class_1937 level, class_243 pos, class_243 speed, float partialTick) {
        pos = pos.method_1037(-entity.method_5695(partialTick) * ((float)Math.PI / 180));
        pos = pos.method_1024(-entity.method_5705(partialTick) * ((float)Math.PI / 180));
        pos = pos.method_1031(entity.method_23317(), entity.method_23320(), entity.method_23321());
        level.method_8406(options, pos.method_10216(), pos.method_10214(), pos.method_10215(), speed.method_10216(), speed.method_10214(), speed.method_10215());
    }

    public static void spawnEnderEyePlacementParticles(class_2338 pos, class_5819 random, class_1937 level, int color) {
        if (ModConfigs.BLOCKS.enderEyePlacedRings) {
            level.method_8406((class_2394)class_9381.method_58256(ModParticles.ENDER_EYE_PLACED_RING.get(), (int)color), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.8125 + (double)0.2501f, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
        }
        if (ModConfigs.BLOCKS.enderEyePlacedParticlesDisplayType != ModBlockConfigs.EnderEyePlacedParticlesDisplayType.VANILLA) {
            ParticleSpawnUtil.spawnEndPortalParticles(level, pos, random, (class_2394)class_9381.method_58256(ModParticles.SHORT_SPARK.get(), (int)color), 16);
        }
    }

    public static void spawnEndPortalParticles(class_1937 level, class_2338 pos, class_5819 random, class_2394 particle, int count) {
        for (int i = 0; i < count; ++i) {
            level.method_8406(particle, (double)pos.method_10263() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), (double)pos.method_10264() + 0.9375, (double)pos.method_10260() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesAroundShape(class_2394 particle, class_1937 level, class_2338 pos, class_2680 state, int count, Supplier<class_243> particleSpeed, float offset) {
        class_2756 half;
        class_2338 oppositePos;
        class_2680 oppositeState;
        if (state.method_28498((class_2769)class_2741.field_12533) && (oppositeState = level.method_8320(oppositePos = pos.method_10093((half = (class_2756)state.method_11654((class_2769)class_2741.field_12533)).method_54779()))).method_27852(state.method_26204()) && oppositeState.method_28498((class_2769)class_2741.field_12533) && half.method_54780().equals((Object)oppositeState.method_11654((class_2769)class_2741.field_12533))) {
            ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, oppositePos, state, direction -> half == class_2756.field_12607 && direction == class_2350.field_11036 || half == class_2756.field_12609 && direction == class_2350.field_11033, count, particleSpeed, offset);
        }
        ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, pos, state, null, count, particleSpeed, offset);
    }

    public static void spawnParticlesAroundShape(class_2394 particle, class_1937 level, class_2338 pos, class_2680 state, @Nullable Predicate<class_2350> predicate, int count, Supplier<class_243> particleSpeed, float offset) {
        class_5819 random = level.method_8409();
        state.method_26218((class_1922)level, pos).method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            for (class_2350 direction : class_2350.values()) {
                class_2338 relativePos;
                if (predicate != null && predicate.test(direction) || level.method_8320(relativePos = pos.method_10093(direction)).method_26216()) continue;
                class_2350.class_2351 axis = direction.method_10166();
                class_2350.class_2352 axisDirection = direction.method_10171();
                boolean isPositive = axisDirection == class_2350.class_2352.field_11056;
                for (int i = 0; i < count; ++i) {
                    double yOffset;
                    double xOffset;
                    double d = axis == class_2350.class_2351.field_11048 ? (isPositive ? maxX : minX) : (xOffset = class_3532.method_15366((class_5819)random, (double)minX, (double)maxX));
                    double d2 = axis == class_2350.class_2351.field_11052 ? (isPositive ? maxY : minY) : (yOffset = class_3532.method_15366((class_5819)random, (double)minY, (double)maxY));
                    double zOffset = axis == class_2350.class_2351.field_11051 ? (isPositive ? maxZ : minZ) : class_3532.method_15366((class_5819)random, (double)minZ, (double)maxZ);
                    class_243 speed = (class_243)particleSpeed.get();
                    level.method_8406(particle, (double)pos.method_10263() + xOffset + (double)(offset * (float)axisDirection.method_10181()), (double)pos.method_10264() + yOffset + (double)(offset * (float)axisDirection.method_10181()), (double)pos.method_10260() + zOffset + (double)(offset * (float)axisDirection.method_10181()), speed.method_10216(), speed.method_10214(), speed.method_10215());
                }
            }
        });
    }

    public static void spawnHammeringWorkstationParticles(class_2338 pos, class_5819 random, class_1937 level) {
        float pointX = random.method_43057();
        float pointZ = random.method_43057();
        for (int i2 = 0; i2 < 20; ++i2) {
            int xSign = MathUtil.nextSign(random);
            int zSign = MathUtil.nextSign(random);
            level.method_8406((class_2394)SparkParticle.create(SparkType.METAL, random), (double)((float)pos.method_10263() + pointX), (double)(pos.method_10264() + 1), (double)((float)pos.method_10260() + pointZ), (double)(class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f) * (float)xSign), (double)class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f), (double)(class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f) * (float)zSign));
        }
    }

    public static void spawnCompostParticles(class_1937 level, class_2338 pos, class_2394 particle, double xSpeed, double ySpeed, double zSpeed) {
        class_5819 random = level.method_8409();
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof class_3962) {
            for (int i = 0; i < 10; ++i) {
                level.method_8406(particle, (double)pos.method_10263() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), (double)pos.method_10264() + 0.1875 + 0.125 * (double)((Integer)state.method_11654((class_2769)class_3962.field_17565)).intValue(), (double)pos.method_10260() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), xSpeed, ySpeed, zSpeed);
            }
        }
    }

    public static void spawnBucketParticles(class_1937 level, class_2338 pos, class_1799 stack) {
        if (level.field_9236) {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof BucketItemAccessor) {
                BucketItemAccessor bucket = (BucketItemAccessor)class_17922;
                class_3611 content = bucket.getContent();
                boolean isWater = content.method_15780((class_3611)class_3612.field_15910);
                if (isWater && ModConfigs.ITEMS.waterBucketUseParticles || content.method_15780((class_3611)class_3612.field_15908) && ModConfigs.ITEMS.lavaBucketUseParticles) {
                    if (isWater && level.method_8597().comp_644()) {
                        return;
                    }
                    ParticleSpawnUtil.spawnBucketParticles(level, pos, Util.getParticleForFluid(content));
                }
            } else if (stack.method_31574(class_1802.field_27876) && ModConfigs.ITEMS.powderSnowBucketUseParticles) {
                ParticleSpawnUtil.spawnBucketParticles(level, pos, (class_2394)ModParticles.SNOW.get());
            }
        }
    }

    public static void spawnBucketParticles(class_1937 level, class_2338 pos, class_2394 particle) {
        if (particle != null) {
            class_5819 random = level.method_8409();
            class_3610 fluidState = level.method_8316(pos);
            double fluidHeight = fluidState.method_15763((class_1922)level, pos);
            for (int i = 0; i < 16; ++i) {
                level.method_8406(particle, (double)pos.method_10263() + 0.5 + MathUtil.nextNonAbsDouble(random), (double)pos.method_10264() + (fluidHeight == 0.0 ? random.method_43058() : fluidHeight), (double)pos.method_10260() + 0.5 + MathUtil.nextNonAbsDouble(random), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnGrindstoneUsedParticles(class_1937 level, class_2338 pos, class_2680 state, class_5819 random) {
        if (ModConfigs.BLOCKS.grindstoneUseParticles && state.method_28498((class_2769)class_3713.field_11177) && state.method_28498((class_2769)class_3713.field_11007)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_3713.field_11177);
            class_2738 face = (class_2738)state.method_11654((class_2769)class_3713.field_11007);
            class_2350 side = face == class_2738.field_12473 ? class_2350.field_11033 : class_2350.field_11036;
            for (int i = 0; i < 20; ++i) {
                ParticleSpawnUtil.spawnParticlesOnSide((class_2394)SparkParticle.create(SparkType.METAL, random), 0.0f, side, level, pos, random, (double)class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f) * ((double)direction.method_10148() * 1.5), face == class_2738.field_12473 ? 0.0 : (double)class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f), (double)class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f) * ((double)direction.method_10165() * 1.5));
            }
        }
    }

    public static void spawnStonecutterParticles(class_1937 level, class_1799 stack, class_2338 pos, class_2680 state) {
        if (!ModConfigs.BLOCKS.stonecutterUseParticles) {
            return;
        }
        class_5819 random = level.method_8409();
        if (state.method_28498((class_2769)class_3718.field_17649)) {
            class_2350 direction = ((class_2350)state.method_11654((class_2769)class_3718.field_17649)).method_10170();
            for (int i = 0; i < 16; ++i) {
                ParticleSpawnUtil.spawnParticlesOnSide((class_2394)new class_2392(class_2398.field_11218, stack), -0.125f, class_2350.field_11036, level, pos, random, (double)class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f) * ((double)direction.method_10148() * 1.5), class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f), (double)class_3532.method_15344((class_5819)random, (float)0.1f, (float)0.2f) * ((double)direction.method_10165() * 1.5));
            }
        }
    }
}

