/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.biome_particles;

import einstein.subtle_effects.biome_particles.BiomeParticleSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class BiomeParticleManager {
    private static final List<BiomeParticleSettings> REGISTERED = new ArrayList<BiomeParticleSettings>();
    private static final class_2338.class_2339 BIOME_POS = new class_2338.class_2339();
    private static final BiPredicate<class_1937, class_2338> NOT_RAINING = (level, pos) -> !level.method_8419();
    public static final BiPredicate<class_1937, class_2338> FIREFLY_CONDITIONS = NOT_RAINING.and((level, pos) -> {
        float time = (float)level.method_8532() % 24000.0f;
        return time > 13000.0f && time < 23000.0f && level.method_8314(class_1944.field_9282, pos) <= 5 && ((class_1959)level.method_23753(pos).comp_349()).method_39927(pos, level.method_8615());
    });
    private static boolean HAS_CLEARED;

    public static void init() {
        BiomeParticleManager.register(ModConfigs.ENVIRONMENT.biomes.mushroomSporeBiomes, ModConfigs.ENVIRONMENT.biomes.mushroomSporeDensity, 40, ModParticles.MUSHROOM_SPORE, NOT_RAINING);
        BiomeParticleManager.register(ModConfigs.ENVIRONMENT.biomes.fireflyBiomes, ModConfigs.ENVIRONMENT.biomes.fireflyDensity, 10, ModParticles.FIREFLY, FIREFLY_CONDITIONS);
        BiomeParticleManager.register(ModConfigs.ENVIRONMENT.biomes.pollenBiomes, ModConfigs.ENVIRONMENT.biomes.pollenDensity, 10, ModParticles.POLLEN, NOT_RAINING);
        BiomeParticleManager.register(ModConfigs.ENVIRONMENT.biomes.sculkDustBiomes, ModConfigs.ENVIRONMENT.biomes.sculkDustDensity, ModParticles.SCULK_DUST, (level, pos) -> true);
    }

    private static void register(ValidatedList<class_2960> biomesConfig, ValidatedInt density, int maxSpawnHeight, Supplier<? extends class_2394> particle, BiPredicate<class_1937, class_2338> spawnConditions) {
        REGISTERED.add(new BiomeParticleSettings(biomesConfig, density, maxSpawnHeight, particle, spawnConditions, false));
    }

    private static void register(ValidatedList<class_2960> biomesConfig, ValidatedInt density, Supplier<? extends class_2394> particle, BiPredicate<class_1937, class_2338> spawnConditions) {
        REGISTERED.add(new BiomeParticleSettings(biomesConfig, density, 0, particle, spawnConditions, true));
    }

    public static void tickBiomeParticles(class_1937 level, class_1657 player) {
        int radius;
        if (HAS_CLEARED) {
            HAS_CLEARED = false;
            REGISTERED.forEach(settings -> settings.update(level));
        }
        if ((radius = ((Integer)ModConfigs.ENVIRONMENT.biomes.biomeParticlesRadius.get()).intValue()) <= 0) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            class_5819 random = level.method_8409();
            int x = player.method_31477() + random.method_43048(radius) - random.method_43048(radius);
            int y = player.method_31478() + random.method_43048(radius) - random.method_43048(radius);
            int z = player.method_31479() + random.method_43048(radius) - random.method_43048(radius);
            BIOME_POS.method_10103(x, y, z);
            if (level.method_31601(y)) continue;
            class_6880 biome = level.method_23753((class_2338)BIOME_POS);
            for (BiomeParticleSettings settings2 : REGISTERED) {
                class_2680 state;
                int surfaceLevel;
                List<class_1959> biomes;
                if (settings2.getDensity() <= i || !settings2.checkSpawnConditions(level, (class_2338)BIOME_POS) || (biomes = settings2.getBiomes()).isEmpty() || !settings2.ignoreHeight() && ((surfaceLevel = level.method_8624(class_2902.class_2903.field_13197, x, z)) > y || surfaceLevel + settings2.getMaxSpawnHeight() < y) || !biomes.contains(biome.comp_349()) || (state = level.method_8320((class_2338)BIOME_POS)).method_26234((class_1922)level, (class_2338)BIOME_POS)) continue;
                level.method_8406(settings2.getParticle().get(), (double)x + random.method_43058(), (double)y + random.method_43058(), (double)z + random.method_43058(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void clear() {
        REGISTERED.forEach(BiomeParticleSettings::clear);
        HAS_CLEARED = true;
    }
}

