/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.world.block.entity.util;

import com.google.common.base.Preconditions;
import forge.com.cursee.disenchanting_table.core.world.block.entity.util.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SimpleInventoryBlockEntity
extends ModBlockEntity
implements Clearable {
    private final SimpleContainer itemHandler = this.createItemHandler();

    protected SimpleInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.addListener(i -> this.setChanged());
    }

    public static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.getContainerSize() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.setItem(i, (ItemStack)src.get(i));
        }
    }

    public static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ret.set(i, (Object)inv.getItem(i));
        }
        return ret;
    }

    @Override
    public void readPacketNBT(CompoundTag tag, HolderLookup.Provider registries) {
        NonNullList tmp = NonNullList.withSize((int)this.inventorySize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)tmp, (HolderLookup.Provider)registries);
        SimpleInventoryBlockEntity.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
    }

    @Override
    public void writePacketNBT(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, SimpleInventoryBlockEntity.copyFromInv((Container)this.itemHandler), (HolderLookup.Provider)registries);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.itemHandler.getItems(), (HolderLookup.Provider)registries);
        super.saveAdditional(tag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        NonNullList tmp = NonNullList.withSize((int)this.inventorySize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)tmp, (HolderLookup.Provider)registries);
        SimpleInventoryBlockEntity.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
    }

    public final int inventorySize() {
        return 3;
    }

    protected abstract SimpleContainer createItemHandler();

    public void clearContent() {
        this.getItemHandler().clearContent();
    }

    public final Container getItemHandler() {
        return this.itemHandler;
    }

    public void setInventory(NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.getItemHandler().setItem(i, (ItemStack)items.get(i));
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        SimpleInventoryBlockEntity simpleInventoryBlockEntity = this;
        if (simpleInventoryBlockEntity instanceof Container) {
            Container container = (Container)simpleInventoryBlockEntity;
            if (this.level != null) {
                Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)container);
            }
        }
    }
}

