/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table.core.util;

import net.minecraft.class_1657;

public class ExperienceHelper {
    public static boolean hasEnoughExperiencePoints(class_1657 player, int amount) {
        if (player.method_68878()) {
            return true;
        }
        return amount <= 0 || ExperienceHelper.getTotalPlayerExperiencePoints(player) >= amount;
    }

    public static boolean hasEnoughExperienceLevels(class_1657 player, int amount) {
        if (player.method_68878()) {
            return true;
        }
        return amount <= 0 || ExperienceHelper.getTotalPlayerExperienceLevels(player) >= amount;
    }

    private static int getTotalPlayerExperienceLevels(class_1657 player) {
        return player.field_7520;
    }

    public static void deductExperiencePoints(class_1657 player, int amount) {
        if (amount <= 0) {
            return;
        }
        int playerXP = ExperienceHelper.getTotalPlayerExperiencePoints(player);
        if (playerXP >= amount) {
            ExperienceHelper.addExperiencePoints(player, -amount);
        }
    }

    public static void deductExperienceLevels(class_1657 player, int amount) {
        if (amount <= 0) {
            return;
        }
        player.field_7520 -= amount;
    }

    public static int getTotalPlayerExperiencePoints(class_1657 player) {
        return (int)((float)ExperienceHelper.getExperiencePointsFromLevel(player.field_7520) + player.field_7510 * (float)player.method_7349());
    }

    public static void addExperiencePoints(class_1657 player, int amount) {
        int experience;
        player.field_7495 = experience = ExperienceHelper.getTotalPlayerExperiencePoints(player) + amount;
        player.field_7520 = ExperienceHelper.getLevelFromExperiencePoints(experience);
        int expForLevel = ExperienceHelper.getExperiencePointsFromLevel(player.field_7520);
        player.field_7510 = (float)(experience - expForLevel) / (float)player.method_7349();
    }

    public static void addExperienceLevels(class_1657 player, int amount) {
        player.field_7520 += amount;
    }

    public static int getHighestExperienceAtLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getExperiencePointsFromLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceHelper.arithmeticSeriesSum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceHelper.arithmeticSeriesSum(level - 15, 37, 5);
        }
        return 1395 + ExperienceHelper.arithmeticSeriesSum(level - 30, 112, 9);
    }

    public static int getLevelFromExperiencePoints(int amount) {
        int level = 0;
        int xpToNextLevel;
        while (amount >= (xpToNextLevel = ExperienceHelper.getHighestExperienceAtLevel(level))) {
            ++level;
            amount -= xpToNextLevel;
        }
        return level;
    }

    private static int arithmeticSeriesSum(int n, int a, int d) {
        return n / 2 * (2 * a + (n - 1) * d);
    }
}

