/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.config;

import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import snownee.jade.JadeInternals;
import snownee.jade.api.SimpleStringRepresentable;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.Theme;

@ApiStatus.NonExtendable
public interface IWailaConfig {
    public static IWailaConfig get() {
        return JadeInternals.getWailaConfig();
    }

    public General general();

    public Overlay overlay();

    public Formatting formatting();

    public Accessibility accessibility();

    public IPluginConfig plugin();

    public void save();

    public void invalidate();

    public String getName();

    public void setName(String var1);

    @ApiStatus.NonExtendable
    public static interface Accessibility {
        public boolean shouldEnableTextToSpeech();

        public void toggleTTS();

        public TTSMode getTTSMode();

        public void setTTSMode(TTSMode var1);

        public boolean getEnableAccessibilityPlugin();

        public void setEnableAccessibilityPlugin(boolean var1);

        public boolean getFlipMainHand();

        public void setFlipMainHand(boolean var1);

        public float tryFlip(float var1);

        public void setTextBackgroundOpacity(float var1);

        public float getTextBackgroundOpacity();

        public void setNarrateKeys(boolean var1);

        public boolean getNarrateKeys();
    }

    @ApiStatus.NonExtendable
    public static interface Formatting {
        public class_2583 getItemModNameStyle();

        public void setItemModNameStyle(class_2583 var1);

        public class_2561 registryName(String var1);
    }

    @ApiStatus.NonExtendable
    public static interface Overlay {
        public static int applyAlpha(int color, float alpha) {
            if (alpha == 0.0f) {
                return 0;
            }
            int prevAlphaChannel = class_9848.method_61320((int)color);
            if (prevAlphaChannel > 0) {
                alpha *= (float)prevAlphaChannel / 256.0f;
            }
            int alphaChannel = class_3532.method_15340((int)((int)(255.0f * alpha)), (int)4, (int)255);
            return class_9848.method_61330((int)alphaChannel, (int)color);
        }

        public float getOverlayPosX();

        public void setOverlayPosX(float var1);

        public float getOverlayPosY();

        public void setOverlayPosY(float var1);

        public float getOverlayScale();

        public void setOverlayScale(float var1);

        public float getAnchorX();

        public void setAnchorX(float var1);

        public float getAnchorY();

        public void setAnchorY(float var1);

        public boolean getSquare();

        public void setSquare(boolean var1);

        public float getAutoScaleThreshold();

        public float getAlpha();

        public void setAlpha(float var1);

        public Theme getTheme();

        public void applyTheme(class_2960 var1);

        public boolean shouldShowIcon();

        public IconMode getIconMode();

        public void setIconMode(IconMode var1);

        public boolean getAnimation();

        public void setAnimation(boolean var1);

        public float getDisappearingDelay();

        public void setDisappearingDelay(float var1);
    }

    @ApiStatus.NonExtendable
    public static interface General {
        public void setDisplayTooltip(boolean var1);

        public boolean getDisplayEntities();

        public void setDisplayEntities(boolean var1);

        public boolean getDisplayBosses();

        public void setDisplayBosses(boolean var1);

        public boolean getDisplayBlocks();

        public void setDisplayBlocks(boolean var1);

        public void setHideFromTabList(boolean var1);

        public void setHideFromGUIs(boolean var1);

        public void setItemModNameTooltip(boolean var1);

        public boolean shouldDisplayTooltip();

        public DisplayMode getDisplayMode();

        public void setDisplayMode(DisplayMode var1);

        public boolean shouldHideFromTabList();

        public boolean shouldHideFromGUIs();

        public boolean shouldDisplayFluids();

        public FluidMode getDisplayFluids();

        public void setDisplayFluids(boolean var1);

        public void setDisplayFluids(FluidMode var1);

        public boolean showItemModNameTooltip();

        public float getExtendedReach();

        public void setExtendedReach(float var1);

        public BossBarOverlapMode getBossBarOverlapMode();

        public void setBossBarOverlapMode(BossBarOverlapMode var1);

        public boolean isDebug();

        public void setDebug(boolean var1);

        public boolean getBuiltinCamouflage();

        public void setBuiltinCamouflage(boolean var1);

        public PerspectiveMode getPerspectiveMode();

        public void setPerspectiveMode(PerspectiveMode var1);
    }

    public static enum HandlerDisplayStyle implements SimpleStringRepresentable
    {
        PROGRESS_BAR,
        ICON,
        PLAIN_TEXT;

    }

    public static enum PerspectiveMode implements SimpleStringRepresentable
    {
        CAMERA,
        EYE;

    }

    public static enum BossBarOverlapMode implements SimpleStringRepresentable
    {
        NO_OPERATION,
        HIDE_BOSS_BAR,
        HIDE_TOOLTIP,
        PUSH_DOWN;

    }

    public static enum FluidMode implements SimpleStringRepresentable
    {
        NONE(class_3959.class_242.field_1348),
        ANY(class_3959.class_242.field_1347),
        FALLBACK(class_3959.class_242.field_1348);

        public final class_3959.class_242 ctx;

        private FluidMode(class_3959.class_242 ctx) {
            this.ctx = ctx;
        }
    }

    public static enum DisplayMode implements SimpleStringRepresentable
    {
        HOLD_KEY,
        TOGGLE,
        LITE;

    }

    public static enum TTSMode implements SimpleStringRepresentable
    {
        TOGGLE,
        PRESS;

    }

    public static enum IconMode implements SimpleStringRepresentable
    {
        TOP,
        CENTERED,
        INLINE,
        HIDE;

    }
}

