/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public abstract class ProgressProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
StreamServerDataProvider<T, Map.Entry<class_2960, List<ViewGroup<ProgressView.Data>>>> {
    private static final class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<ProgressView.Data>>>> STREAM_CODEC = ViewGroup.listCodec(ProgressView.Data.STREAM_CODEC).method_56430();

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        List groups = ClientProxy.mapToClientGroups(accessor, JadeIds.UNIVERSAL_PROGRESS, STREAM_CODEC, WailaClientRegistration.instance().progressProviders::get, tooltip);
        if (groups == null || groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        BoxStyle.GradientBorder boxStyle = BoxStyle.getTransparent().clone();
        boxStyle.bgColor = 0x44FFFFFF;
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (ProgressView view : group.views) {
                if (view.text != null) {
                    theTooltip.add(helper.text(view.text).scale(0.75f));
                    theTooltip.setLineMargin(-1, ScreenDirection.DOWN, 0);
                }
                theTooltip.add(helper.progress(view.progress, null, view.style, boxStyle, false).size(new class_241(10.0f, 2.0f)));
            }
        });
    }

    @Override
    @Nullable
    public Map.Entry<class_2960, List<ViewGroup<ProgressView.Data>>> streamData(T accessor) {
        return CommonProxy.getServerExtensionData(accessor, WailaCommonRegistration.instance().progressProviders);
    }

    @Override
    public class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<ProgressView.Data>>>> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        return WailaCommonRegistration.instance().progressProviders.hitsAny((Accessor<?>)accessor, (BiPredicate<IServerExtensionProvider<ProgressView.Data>, Accessor<?>>)((BiPredicate<IServerExtensionProvider, Accessor>)IServerExtensionProvider::shouldRequestData));
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.UNIVERSAL_PROGRESS;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    public static class ForBlock
    extends ProgressProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends ProgressProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }
}

