/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.config.serialize.placement.PlacementConfig;
import de.cristelknight.cristellib.data.StructureSetHolder;
import de.cristelknight.cristellib.util.JanksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ReadStructureSets {
    public static Map<class_2960, List<String>> readSetsAndAddStructures(List<StructureSetHolder> structureSetHolder) {
        HashMap<class_2960, List<String>> structures = new HashMap<class_2960, List<String>>();
        structureSetHolder.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement e = JanksonUtil.getSetElement(modID, setLocation);
            if (ReadStructureSets.checkElement(e, modID, setLocation)) {
                return;
            }
            JsonArray structureArray = class_3518.method_15261((JsonObject)e.getAsJsonObject(), (String)"structures");
            ArrayList<String> structureList = new ArrayList<String>();
            for (JsonElement element : structureArray) {
                if (!element.isJsonObject()) continue;
                structureList.add(class_3518.method_15265((JsonObject)element.getAsJsonObject(), (String)"structure"));
            }
            structures.put((class_2960)setLocation, (List<String>)structureList);
        }));
        return structures;
    }

    public static Map<String, PlacementConfig> readSetsAndAddPlacements(List<StructureSetHolder> structureSetHolder) {
        HashMap<String, PlacementConfig> structurePlacement = new HashMap<String, PlacementConfig>();
        structureSetHolder.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement e = JanksonUtil.getSetElement(modID, setLocation);
            if (ReadStructureSets.checkElement(e, modID, setLocation)) {
                return;
            }
            JsonObject placement = class_3518.method_15296((JsonObject)e.getAsJsonObject(), (String)"placement");
            PlacementConfig config = ConfigManager.readElement(String.format("Couldn't read %s in %s, crashing instead. Maybe try to delete the config files!", setLocation, modID), PlacementConfig.CODEC, JsonOps.INSTANCE, placement);
            structurePlacement.put(setLocation.method_12832(), config);
        }));
        return structurePlacement;
    }

    private static boolean checkElement(JsonElement element, String modID, class_2960 setLocation) {
        if (!element.isJsonObject()) {
            CristelLib.LOGGER.error("Set for {} {} is not a JsonObject", (Object)modID, (Object)setLocation);
            return true;
        }
        return false;
    }
}

