/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.data;

import com.mojang.datafixers.util.Either;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPackLoader;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.data.BuiltInPackData;
import de.cristelknight.cristellib.data.BuiltInPackDataWrapper;
import de.cristelknight.cristellib.data.Conditions;
import de.cristelknight.cristellib.data.CopyFileData;
import de.cristelknight.cristellib.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.io.FileUtils;

public class ReadData {
    private static boolean checkedConfigFiles = false;

    public static void getStructureConfigs(String modId, Map<String, Set<StructureConfig>> modIdAndConfigs) {
        HashSet<StructureConfig> configs = new HashSet<StructureConfig>();
        for (Path path : ReadData.getPathsInDir(modId, "structure_config")) {
            StructureConfig config = ConfigManager.readFromJsonPath(String.format("Couldn't read %s, crashing instead. This file is corrupted!", path), path, StructureConfig.CODEC);
            configs.add(config);
        }
        checkedConfigFiles = false;
        if (configs.isEmpty()) {
            return;
        }
        modIdAndConfigs.put(modId, configs);
    }

    public static void getBuiltInPacks(String modId) {
        for (Path path : ReadData.getPathsInDir(modId, "data_pack")) {
            Either<BuiltInPackData, BuiltInPackDataWrapper> either = ConfigManager.readFromJsonPath(String.format("Couldn't read %s, crashing instead. This file is corrupted!", path), path, BuiltInPackData.PACKS_CODEC);
            either.left().ifPresent(ReadData::loadPack);
            either.right().ifPresent(wrapper -> {
                ArrayList<BuiltInPackData> packs = new ArrayList<BuiltInPackData>(wrapper.packs());
                Collections.reverse(packs);
                packs.forEach(ReadData::loadPack);
            });
        }
        checkedConfigFiles = false;
    }

    public static void loadPack(BuiltInPackData pack) {
        boolean bl = Conditions.readConditions(pack.conditions());
        BuiltInDataPackLoader.registerPack(pack.location(), class_2561.method_30163((String)pack.displayName()), () -> bl);
    }

    public static void copyFile(String modId) {
        for (Path path : ReadData.getPathsInDir(modId, "copy_file")) {
            CopyFileData copyFileData = ConfigManager.readFromJsonPath(String.format("Couldn't read %s, crashing instead. This file is corrupted!", path), path, CopyFileData.CODEC);
            if (!Conditions.readConditions(copyFileData.conditions())) continue;
            ReadData.copyFileFromJar(copyFileData.location(), copyFileData.destination());
        }
        checkedConfigFiles = false;
    }

    public static void copyFileFromJar(class_2960 from, String to) {
        String modID = from.method_12836();
        String location = from.method_12832();
        List<Path> inputUrl = CristelLibExpectPlatform.getRootPaths(modID);
        for (Path p : inputUrl) {
            Path fromFile = p.resolve(location);
            File toFile = Util.pathFromString(to).toFile();
            if (fromFile == null || toFile == null || toFile.exists()) continue;
            try {
                FileUtils.copyURLToFile((URL)fromFile.toUri().toURL(), (File)toFile);
            }
            catch (IOException e) {
                CristelLib.LOGGER.error("Couldn't copy file from: {} to: {}", (Object)fromFile, (Object)toFile, (Object)e);
            }
        }
    }

    public static List<Path> getPathsInDir(String modId, String subPath) {
        ArrayList<Path> paths = new ArrayList<Path>();
        ReadData.findFiles(CristelLibExpectPlatform.getRootPaths(modId), modId, String.format("data/cristellib/%s", subPath), x$0 -> Files.exists(x$0, new LinkOption[0]), (path, file) -> {
            if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")) {
                paths.add((Path)file);
            }
            return true;
        }, true, Integer.MAX_VALUE);
        return paths;
    }

    public static void findFiles(List<Path> rootPaths, String modId, String subPath, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) {
        if (modId.equals("minecraft")) {
            return;
        }
        if (!checkedConfigFiles) {
            ReadData.findInConfigFiles(subPath, rootFilter, processor, visitAllFiles, maxDepth);
            checkedConfigFiles = true;
        }
        try {
            boolean hasOldPath = false;
            boolean hasNewPath = false;
            for (Path root : rootPaths) {
                Path newPath = root.resolve(subPath);
                if (!hasOldPath) {
                    hasOldPath = Files.exists(root.resolve(subPath + "s"), new LinkOption[0]);
                }
                if (!hasNewPath) {
                    hasNewPath = Files.exists(newPath, new LinkOption[0]);
                }
                ReadData.walk(newPath, rootFilter, processor, visitAllFiles, maxDepth);
            }
            if (hasOldPath && !hasNewPath) {
                CristelLib.LOGGER.error("Mod with id {} only has an old path for subPath {}. New Path for Cristel Lib >=2.0.1 is missing! Maybe contact the mod author to let them know.", (Object)modId, (Object)subPath);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void findInConfigFiles(String subPath, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) {
        try {
            ReadData.walk(ConfigManager.CONFIG_LIB.resolve(subPath), rootFilter, processor, visitAllFiles, maxDepth);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void walk(Path root, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0]) || !rootFilter.test(root)) {
            return;
        }
        if (processor == null) {
            return;
        }
        try (Stream<Path> stream = Files.walk(root, maxDepth, new FileVisitOption[0]);){
            Iterator itr = stream.iterator();
            while (itr.hasNext()) {
                boolean keepGoing = processor.apply(root, (Path)itr.next());
                if (visitAllFiles || keepGoing) continue;
                return;
            }
        }
    }
}

