/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config.serialize.ed;

import de.cristelknight.cristellib.config.serialize.ed.NestedEDConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class EDConfigTransformer {
    public static Map<String, Boolean> stringBooleanMap(NestedEDConfig edConfig, String parent) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (Map.Entry<String, NestedEDConfig.Entry> entry : edConfig.entries().entrySet()) {
            String finalKey;
            String key = entry.getKey();
            NestedEDConfig.Entry object = entry.getValue();
            String string = finalKey = parent.isEmpty() ? key : parent + "/" + key;
            if (object.isBoolean()) {
                map.put(finalKey, object.value());
                continue;
            }
            map.putAll(EDConfigTransformer.stringBooleanMap(object.nested(), key));
        }
        return map;
    }

    public static Map<String, NestedEDConfig> mapToNestedStructures(Map<class_2960, List<String>> sets) {
        HashMap<String, NestedEDConfig> nestedStructures = new HashMap<String, NestedEDConfig>();
        for (Map.Entry<class_2960, List<String>> mapEntry : sets.entrySet()) {
            class_2960 location = mapEntry.getKey();
            List<String> stringList = mapEntry.getValue();
            HashMap<String, NestedEDConfig.Entry> entries = new HashMap<String, NestedEDConfig.Entry>();
            for (String structure : stringList) {
                String structureName = structure.split(":")[1];
                EDConfigTransformer.putStructureName(structureName, entries);
            }
            NestedEDConfig nestedStructure = new NestedEDConfig(entries);
            nestedStructures.put(location.toString().split(":")[1], nestedStructure);
        }
        return nestedStructures;
    }

    public static void putStructureName(String structureName, Map<String, NestedEDConfig.Entry> entries) {
        if (structureName.contains("/")) {
            String[] parts = structureName.split("/", 2);
            String key = parts[0];
            String restOfStructureName = parts[1];
            boolean containsNestedStructure = entries.containsKey(key);
            Map<String, NestedEDConfig.Entry> nestedEntries = containsNestedStructure ? entries.get(key).nested().entries() : new HashMap<String, NestedEDConfig.Entry>();
            EDConfigTransformer.putStructureName(restOfStructureName, nestedEntries);
            if (!containsNestedStructure) {
                entries.put(key, NestedEDConfig.Entry.ofNested(new NestedEDConfig(nestedEntries)));
            }
        } else {
            entries.put(structureName, NestedEDConfig.Entry.ofBoolean(true));
        }
    }
}

