/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.builtinpacks.BuiltInPack;
import de.cristelknight.cristellib.builtinpacks.BuiltinResourcePackSource;
import de.cristelknight.cristellib.data.BuiltInPackConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.NotNull;

public class BuiltInDataPackLoader {
    private static final List<BuiltInPack> PACK_LIST = new ArrayList<BuiltInPack>();
    private static boolean frozen = false;

    public static void registerAlwaysOnPack(class_2960 path, class_2561 displayName) {
        BuiltInDataPackLoader.registerPack(path, displayName, () -> true);
    }

    public static void registerPack(class_2960 path, class_2561 displayName, Supplier<Boolean> supplier) {
        BuiltInDataPackLoader.registerPack(CristelLibExpectPlatform.registerBuiltinResourcePack(path, displayName), displayName, supplier);
    }

    public static void registerPack(class_3262 packResource, class_2561 displayName, Supplier<Boolean> supplier) {
        if (frozen) {
            throw new RuntimeException(CristelLib.getWithPrefix(String.format("BuiltInDataPack Registry is already frozen. Cannot add Pack with id: %s", packResource.method_14409())));
        }
        PACK_LIST.add(new BuiltInPack(packResource, displayName, supplier));
    }

    public static List<String> getIDs() {
        return PACK_LIST.stream().map(pack -> pack.packResource().method_14409()).filter(id -> !id.equals(CristelLib.CRISTEL_LIB_PACK_RL.toString())).toList();
    }

    public static void getPacks(Consumer<class_3288> consumer) {
        if (!frozen) {
            throw new RuntimeException(CristelLib.getWithPrefix("Tried to load Packs before the Registry phase is over!"));
        }
        if (PACK_LIST.isEmpty()) {
            return;
        }
        BuiltInPackConfig config = (BuiltInPackConfig)BuiltInPackConfig.DEFAULT.getConfig();
        for (BuiltInPack entry : PACK_LIST) {
            class_9225 info2;
            final class_3262 pack = entry.packResource();
            if (!entry.supplier().get().booleanValue() || config.disabledPacks().contains(pack.method_14409()) || pack.method_14406(class_3264.field_14190).isEmpty()) continue;
            class_2561 displayName = entry.displayName();
            class_9224 metadata = new class_9224(pack.method_14409(), displayName, (class_5352)new BuiltinResourcePackSource(), pack.method_56929());
            class_3288 profile = class_3288.method_45275((class_9224)metadata, (class_3288.class_7680)new class_3288.class_7680(){

                @NotNull
                public class_3262 method_52424(class_9224 var1) {
                    return pack;
                }

                @NotNull
                public class_3262 method_52425(class_9224 var1, class_3288.class_7679 metadata) {
                    return pack;
                }
            }, (class_3264)class_3264.field_14190, (class_9225)(info2 = new class_9225(true, class_3288.class_3289.field_14280, false)));
            if (profile == null) {
                CristelLib.LOGGER.error("Pack Profile with display name: {} is null", (Object)displayName);
                continue;
            }
            consumer.accept(profile);
        }
    }

    public static void freeze() {
        frozen = true;
    }
}

