/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.ClientMailbox;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeliveryService
extends class_18 {
    private static final class_10741<DeliveryService> TYPE = new class_10741("refurbished_furniture_delivery_service", context -> new DeliveryService(context.method_67417().method_8503()), context -> class_2487.field_25128.xmap(tag -> {
        class_3218 level = context.method_67417();
        MinecraftServer server = level.method_8503();
        class_5455 access = level.method_30349();
        return new DeliveryService(server, (class_2487)tag, (class_7225.class_7874)access);
    }, service -> {
        class_3218 level = context.method_67417();
        class_5455 access = level.method_30349();
        return service.save((class_7225.class_7874)access);
    }), null);
    private final MinecraftServer server;
    private final Map<Pair<class_2960, class_2338>, Mailbox> locator = new HashMap<Pair<class_2960, class_2338>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<class_2960, class_2338>> pendingNames = new HashMap<UUID, Pair<class_2960, class_2338>>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        class_3218 level = server.method_3847(class_1937.field_25179);
        if (level != null) {
            return Optional.of((DeliveryService)level.method_17983().method_17924(TYPE));
        }
        return Optional.empty();
    }

    public DeliveryService(MinecraftServer server) {
        this.server = server;
    }

    public DeliveryService(MinecraftServer server, class_2487 compound, class_7225.class_7874 provider) {
        this.server = server;
        this.load(compound, provider);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void serverTick() {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel();
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().method_29177(), (Object)mailbox2.pos()));
            this.method_80();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick());
    }

    public DeliveryResult sendMail(UUID id, class_1799 stack) {
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox == null) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.unknown_mailbox"));
        }
        if (mailbox.queue().size() >= (Integer)Config.SERVER.mailing.deliveryQueueSize.get()) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.mailbox_queue_full"));
        }
        if (!DeliveryService.isDeliverableDimension(mailbox.levelKey())) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.undeliverable_dimension"));
        }
        mailbox.queue().offer(stack);
        this.method_80();
        return DeliveryResult.createSuccess(Utils.translationKey("gui", "delivery_service.package_sent"));
    }

    void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public boolean canCreateMailbox(class_1657 player) {
        long count = this.mailboxes.values().stream().filter(box -> player.method_5667().equals(box.owner().getValue())).count();
        return (long)((Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get()).intValue() > count;
    }

    public Mailbox getOrCreateMailBox(MailboxBlockEntity blockEntity) {
        this.duplicateIdCheck(blockEntity);
        return this.mailboxes.computeIfAbsent(blockEntity.getId(), uuid -> {
            class_5321 levelKey = blockEntity.method_10997().method_27983();
            class_2338 pos = blockEntity.method_11016();
            Mailbox mailbox = new Mailbox((UUID)uuid, (class_5321<class_1937>)levelKey, pos, (MutableObject<UUID>)new MutableObject(), (MutableObject<String>)new MutableObject((Object)""), (Queue<class_1799>)new ArrayDeque<class_1799>(), new MutableBoolean(), this);
            this.locator.put((Pair<class_2960, class_2338>)Pair.of((Object)levelKey.method_29177(), (Object)pos), mailbox);
            this.method_80();
            return mailbox;
        });
    }

    private void duplicateIdCheck(MailboxBlockEntity blockEntity) {
        Mailbox box = this.mailboxes.get(blockEntity.getId());
        if (box != null && !box.pos().equals((Object)blockEntity.method_11016())) {
            blockEntity.regenerateId();
        }
    }

    public Optional<Mailbox> getMailboxAtPosition(class_1937 level, class_2338 pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.method_27983().method_29177(), (Object)pos)));
    }

    public void markMailboxAsPendingName(class_1657 player, class_1937 level, class_2338 pos) {
        this.pendingNames.put(player.method_5667(), (Pair<class_2960, class_2338>)Pair.of((Object)level.method_27983().method_29177(), (Object)pos));
    }

    public boolean renameMailbox(class_1657 player, class_1937 level, class_2338 pos, String customName) {
        Pair<class_2960, class_2338> pendingLocation = this.pendingNames.remove(player.method_5667());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().getValue(), player.method_5667())) {
                return false;
            }
            Pair location = Pair.of((Object)level.method_27983().method_29177(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public Collection<IMailbox> getMailboxes() {
        return Collections.unmodifiableCollection(this.mailboxes.values());
    }

    public void encodeMailboxes(class_2540 buf) {
        buf.method_34062(this.mailboxes.values(), (buf1, mailbox) -> {
            buf1.method_10797(mailbox.getId());
            buf1.method_37435(mailbox.getOwner(), (buf2, profile) -> {
                buf2.method_10797(profile.getId());
                buf2.method_37435(Optional.ofNullable(profile.getName()), class_2540::method_10814);
            });
            buf1.method_37435(mailbox.getCustomName(), class_2540::method_10814);
        });
    }

    public static List<IMailbox> decodeMailboxes(class_2540 buf) {
        List list = buf.method_34066(buf1 -> {
            UUID mailboxId = buf1.method_10790();
            Optional profile = buf1.method_37436(buf2 -> {
                UUID playerId = buf2.method_10790();
                Optional name = buf2.method_37436(class_2540::method_19772);
                return new GameProfile(playerId, name.orElse("Unknown"));
            });
            Optional mailboxName = buf1.method_37436(class_2540::method_19772);
            return new ClientMailbox(mailboxId, profile, mailboxName);
        });
        return ImmutableList.copyOf((Collection)list);
    }

    private void load(class_2487 compound, class_7225.class_7874 provider) {
        if (compound.method_10545("Mailboxes")) {
            class_2499 list = compound.method_68569("Mailboxes");
            list.forEach(tag -> {
                if (!(tag instanceof class_2487)) {
                    return;
                }
                class_2487 mailboxTag = (class_2487)tag;
                try {
                    class_5321<class_1937> levelKey = DeliveryService.createLevelKey((String)mailboxTag.method_10558("Level").orElseThrow());
                    UUID id = (UUID)mailboxTag.method_67491("UUID", class_4844.field_25122).orElseThrow();
                    class_2338 pos = class_2338.method_10092((long)((Long)mailboxTag.method_10537("BlockPosition").orElseThrow()));
                    MutableObject owner = new MutableObject();
                    if (mailboxTag.method_10545("Owner")) {
                        mailboxTag.method_67491("Owner", class_4844.field_25122).ifPresent(arg_0 -> ((MutableObject)owner).setValue(arg_0));
                    }
                    String customName = mailboxTag.method_10558("CustomName").orElse("Mailbox");
                    customName = customName.substring(0, Math.min(customName.length(), 32));
                    Queue<class_1799> queue = Mailbox.readQueueListTag(mailboxTag, provider);
                    Mailbox mailbox = new Mailbox(id, levelKey, pos, (MutableObject<UUID>)owner, (MutableObject<String>)new MutableObject((Object)customName), queue, new MutableBoolean(), this);
                    this.mailboxes.putIfAbsent(id, mailbox);
                    this.locator.put((Pair<class_2960, class_2338>)Pair.of((Object)levelKey.method_29177(), (Object)pos), mailbox);
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load a mailbox due to invalid data");
                }
            });
        }
    }

    public class_2487 save(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        this.mailboxes.forEach((uuid, mailbox) -> {
            if (!mailbox.removed().booleanValue()) {
                class_2487 mailboxTag = new class_2487();
                mailboxTag.method_67494("UUID", class_4844.field_25122, uuid);
                mailboxTag.method_10582("Level", mailbox.levelKey().method_29177().toString());
                mailboxTag.method_10544("BlockPosition", mailbox.pos().method_10063());
                Optional.ofNullable((UUID)mailbox.owner().getValue()).ifPresent(id -> mailboxTag.method_67494("Owner", class_4844.field_25122, id));
                Optional.ofNullable((String)mailbox.customName().getValue()).ifPresent(name -> mailboxTag.method_10582("CustomName", name));
                mailbox.writeQueue(mailboxTag, provider);
                list.add((Object)mailboxTag);
            }
        });
        tag.method_10566("Mailboxes", (class_2520)list);
        return tag;
    }

    @Nullable
    private static class_5321<class_1937> createLevelKey(String levelKey) {
        class_5321 class_53212;
        if (levelKey.isBlank()) {
            class_53212 = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    class_53212 = class_1937.field_25179;
                    break;
                }
                case "minecraft:the_nether": {
                    class_53212 = class_1937.field_25180;
                    break;
                }
                case "minecraft:the_end": {
                    class_53212 = class_1937.field_25181;
                    break;
                }
                default: {
                    class_53212 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)levelKey));
                }
            }
        }
        return class_53212;
    }

    public static boolean isBannedItem(class_1799 stack) {
        if (((Boolean)Config.SERVER.mailing.banSendingItemsWithInventories.get()).booleanValue() && !stack.method_7909().method_31568()) {
            return true;
        }
        String name = stack.method_7909().method_7876();
        return ((List)Config.SERVER.mailing.bannedItems.get()).contains(name);
    }

    public static boolean isDeliverableDimension(class_1937 level) {
        return DeliveryService.isDeliverableDimension((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isDeliverableDimension(class_5321<class_1937> key) {
        List validDimensions = (List)Config.SERVER.mailing.allowedDimensions.get();
        if (!validDimensions.isEmpty()) {
            return validDimensions.contains(key.method_29177().toString());
        }
        return true;
    }
}

