/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_918;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoItemRenderer<T extends class_1792>
implements GeoRenderer<T, class_1799, GeoRenderState> {
    protected final GeoRenderLayersContainer<T, class_1799, GeoRenderState> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoItemRenderer(GeoModel<T> model) {
        this(class_310.method_1551().method_31975(), class_310.method_1551().method_31974(), model);
    }

    public GeoItemRenderer(class_824 dispatcher, class_5599 modelSet, GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    public GeoItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public List<GeoRenderLayer<T, class_1799, GeoRenderState>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> addRenderLayer(GeoRenderLayer<T, class_1799, GeoRenderState> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, class_1799 itemStack) {
        return GeoItem.getId(itemStack);
    }

    @Override
    @ApiStatus.Internal
    public GeoRenderState captureDefaultRenderState(T animatable, class_1799 itemStack, GeoRenderState renderState, float partialTick) {
        renderState.addGeckolibData(DataTickets.ITEM, animatable);
        renderState.addGeckolibData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, this.getInstanceId(animatable, itemStack));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(renderState.getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID)));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, this.getRenderColor(animatable, itemStack, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, false);
        renderState.addGeckolibData(DataTickets.BONE_RESET_TIME, ((GeoAnimatable)animatable).getBoneResetTime());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, animatable.getClass());
        renderState.addGeckolibData(DataTickets.IS_ENCHANTED, itemStack.method_7942());
        renderState.addGeckolibData(DataTickets.IS_STACKABLE, itemStack.method_7946());
        renderState.addGeckolibData(DataTickets.MAX_USE_DURATION, itemStack.method_7935((class_1309)ClientUtil.getClientPlayer()));
        renderState.addGeckolibData(DataTickets.MAX_DURABILITY, itemStack.method_7936());
        renderState.addGeckolibData(DataTickets.REMAINING_DURABILITY, itemStack.method_7963() ? itemStack.method_7936() - itemStack.method_7919() : 1);
        renderState.addGeckolibData(DataTickets.PER_BONE_TASKS, new Reference2ObjectOpenHashMap(0));
        return renderState;
    }

    @Override
    public void preRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        }
    }

    @Override
    public void adjustPositionForRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        if (!isReRender) {
            poseStack.method_46416(0.5f, 0.51f, 0.5f);
        }
    }

    @Override
    public void scaleModelForRender(GeoRenderState renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, isReRender);
    }

    public void render(GeoRenderState renderState, class_4587 poseStack, class_4597 bufferSource) {
        if (renderState.getGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE) == class_811.field_4317) {
            this.renderInGui(renderState, poseStack, bufferSource);
        } else {
            class_1921 renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
            class_4588 buffer = renderType == null ? null : class_918.method_23181((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (boolean)renderState.getGeckolibData(DataTickets.HAS_GLINT));
            this.defaultRender(renderState, poseStack, bufferSource, renderType, buffer);
        }
    }

    protected void renderInGui(GeoRenderState renderState, class_4587 poseStack, class_4597 bufferSource) {
        class_4597.class_4598 bufferSource2;
        this.setupLightingForGuiRender();
        class_4597.class_4598 defaultBufferSource = bufferSource instanceof class_4597.class_4598 ? (bufferSource2 = (class_4597.class_4598)bufferSource) : class_310.method_1551().field_1769.field_20951.method_23000();
        class_1921 renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        class_4588 buffer = class_918.method_23181((class_4597)bufferSource, (class_1921)renderType, (boolean)true, (boolean)renderState.getGeckolibData(DataTickets.HAS_GLINT));
        poseStack.method_22903();
        this.defaultRender(renderState, poseStack, (class_4597)defaultBufferSource, renderType, buffer);
        defaultBufferSource.method_22993();
        class_308.method_24211();
        poseStack.method_22909();
    }

    @Override
    public void actuallyRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            ((GeoAnimatable)renderState.getGeckolibData(DataTickets.ITEM)).getAnimatableInstanceCache().getManagerForId(renderState.getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID)).setAnimatableData(DataTickets.ITEM_RENDER_PERSPECTIVE, renderState.getGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE));
            this.getGeoModel().handleAnimations(this.createAnimationState(renderState));
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void doPostRenderCleanup() {
        this.itemRenderTranslations = null;
        this.modelRenderTranslations = null;
    }

    @Override
    public void renderRecursively(GeoRenderState renderState, class_4587 poseStack, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(renderState, poseStack, bone, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            class_308.method_34742();
        } else {
            class_308.method_24210();
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, class_1799 itemStack, GeoRenderState renderState) {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderState(this, renderState, animatable, itemStack);
    }

    @Override
    public boolean firePreRenderEvent(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        return GeckoLibServices.Client.EVENTS.fireItemPreRender(this, renderState, poseStack, model, bufferSource);
    }

    @Override
    public void firePostRenderEvent(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        GeckoLibServices.Client.EVENTS.fireItemPostRender(this, renderState, poseStack, model, bufferSource);
    }
}

