/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneCooldowns;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.client.gui.screen.InventoryButtonReturnConfirmScreen;
import net.blay09.mods.waystones.client.gui.widget.WaystoneInventoryButton;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.message.ServerboundInventoryButtonPacket;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class InventoryButtonGuiHandler {
    private static WaystoneInventoryButton warpButton;

    public static void initialize(BalmEvents events) {
        events.onEvent(ScreenInitEvent.Post.class, event -> {
            class_437 screen = event.getScreen();
            if (!(screen instanceof class_490) && !(screen instanceof class_481)) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (screen != mc.field_1755) {
                return;
            }
            InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
            if (!inventoryButtonMode.isEnabled()) {
                return;
            }
            Supplier<Integer> xPosition = screen instanceof class_481 ? () -> WaystonesConfig.getActive().inventoryButton.creativeInventoryButtonX : () -> WaystonesConfig.getActive().inventoryButton.inventoryButtonX;
            Supplier<Integer> yPosition = screen instanceof class_481 ? () -> WaystonesConfig.getActive().inventoryButton.creativeInventoryButtonY : () -> WaystonesConfig.getActive().inventoryButton.inventoryButtonY;
            warpButton = new WaystoneInventoryButton((class_465)screen, button -> {
                WarpRequirement requirements;
                class_746 player = mc.field_1724;
                if (player.method_31549().field_7477) {
                    PlayerWaystoneManager.resetCooldowns((class_1657)player);
                }
                if ((requirements = WaystonesAPI.resolveRequirements(WaystonesAPI.createUnboundTeleportContext((class_1297)player).addFlag(TeleportFlags.INVENTORY_BUTTON))).canAfford((class_1657)player)) {
                    if (inventoryButtonMode.hasNamedTarget()) {
                        mc.method_1507((class_437)new InventoryButtonReturnConfirmScreen(inventoryButtonMode.getNamedTarget()));
                    } else if (inventoryButtonMode.isReturnToNearest()) {
                        if (PlayerWaystoneManager.getNearestWaystone((class_1657)player).isPresent()) {
                            mc.method_1507((class_437)new InventoryButtonReturnConfirmScreen());
                        }
                    } else if (inventoryButtonMode.isReturnToAny()) {
                        Balm.getNetworking().sendToServer((class_8710)ServerboundInventoryButtonPacket.INSTANCE);
                    }
                } else {
                    mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)0.5f));
                }
            }, () -> {
                if (screen instanceof class_481) {
                    class_481 creativeModeInventoryScreen = (class_481)screen;
                    return creativeModeInventoryScreen.method_47424();
                }
                return true;
            }, xPosition, yPosition);
            BalmClient.getScreens().addRenderableWidget(screen, (class_339)warpButton);
        });
        events.onEvent(ScreenDrawEvent.Post.class, event -> {
            class_437 screen = event.getScreen();
            class_332 guiGraphics = event.getGuiGraphics();
            int mouseX = event.getMouseX();
            int mouseY = event.getMouseY();
            if ((screen instanceof class_490 || screen instanceof class_481) && warpButton != null && warpButton.method_25367()) {
                InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                long millisLeft = PlayerWaystoneManager.getCooldownMillisLeft((class_1657)player, WaystoneCooldowns.INVENTORY_BUTTON);
                Waystone waystone = PlayerWaystoneManager.getInventoryButtonTarget((class_1657)player).orElse(InvalidWaystone.INSTANCE);
                WaystoneTeleportContext context = WaystonesAPI.createUnboundTeleportContext((class_1297)player, waystone).addFlag(TeleportFlags.INVENTORY_BUTTON);
                WarpRequirement requirements = WaystonesAPI.resolveRequirements(context);
                if (inventoryButtonMode.hasNamedTarget()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"gui.waystones.inventory.return_to_waystone").method_27692(class_124.field_1054));
                    class_5250 targetComponent = class_2561.method_43470((String)inventoryButtonMode.getNamedTarget()).method_27692(class_124.field_1062);
                    tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.waystones.bound_to", (Object[])new Object[]{targetComponent}).method_27692(class_124.field_1080));
                } else if (inventoryButtonMode.isReturnToNearest()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"gui.waystones.inventory.return_to_nearest_waystone").method_27692(class_124.field_1054));
                    Optional<Waystone> nearestWaystone = PlayerWaystoneManager.getNearestWaystone((class_1657)player);
                    tooltip.add((class_2561)nearestWaystone.map(it -> it.getName().method_27661().method_27692(class_124.field_1062)).map(it -> class_2561.method_43469((String)"tooltip.waystones.bound_to", (Object[])new Object[]{it}).method_27692(class_124.field_1080)).orElseGet(() -> class_2561.method_43471((String)"gui.waystones.inventory.no_waystones_activated").method_27692(class_124.field_1061)));
                } else if (inventoryButtonMode.isReturnToAny()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"gui.waystones.inventory.return_to_waystone").method_27692(class_124.field_1054));
                    if (PlayerWaystoneManager.getActivatedWaystones((class_1657)player).isEmpty()) {
                        tooltip.add((class_2561)class_2561.method_43471((String)"gui.waystones.inventory.no_waystones_activated").method_27692(class_124.field_1061));
                    }
                }
                if (!requirements.canAfford((class_1657)player)) {
                    requirements.appendHoverText((class_1657)player, tooltip);
                }
                guiGraphics.method_64038(class_310.method_1551().field_1772, tooltip, Optional.empty(), mouseX, mouseY);
            }
        });
    }
}

