/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.minecraft.class_10774;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlock
extends WaystoneBlockBase {
    public static final MapCodec<WarpPlateBlock> CODEC = WarpPlateBlock.method_54094(WarpPlateBlock::new);
    private static final class_2583 GALACTIC_STYLE = class_2583.field_24360.method_27704(class_2960.method_60655((String)"minecraft", (String)"alt"));
    private static final class_265 SHAPE = class_259.method_1084((class_265)WarpPlateBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (class_265)WarpPlateBlock.method_9541((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)).method_1097();
    public static final class_2754<WarpPlateStatus> STATUS = class_2754.method_11850((String)"status", WarpPlateStatus.class);

    public static int getColorForBlock(@Nullable class_1920 view, class_2338 pos) {
        class_2586 class_25862;
        if (view == null || !((class_25862 = view.method_8321(pos)) instanceof WarpPlateBlockEntity)) {
            return -1;
        }
        WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)class_25862;
        String name = WarpPlateBlock.getGalacticIdentifier(warpPlate.getWaystone().getWaystoneUid());
        Integer color = WarpPlateBlock.getColorForName(name).method_532();
        return color != null ? color : -1;
    }

    public WarpPlateBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(STATUS, (Comparable)((Object)WarpPlateStatus.EMPTY)));
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return SHAPE;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{STATUS});
    }

    public void method_9548(class_2680 blockState, class_1937 world, class_2338 pos, class_1297 entity, class_10774 effectApplier) {
        class_2586 tileEntity;
        if (entity.method_23317() >= (double)pos.method_10263() && entity.method_23317() < (double)(pos.method_10263() + 1) && entity.method_23318() >= (double)pos.method_10264() && entity.method_23318() < (double)(pos.method_10264() + 1) && entity.method_23321() >= (double)pos.method_10260() && entity.method_23321() < (double)(pos.method_10260() + 1) && !world.field_9236 && (tileEntity = world.method_8321(pos)) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        block5: {
            int i;
            WarpPlateStatus status;
            block6: {
                block4: {
                    status = (WarpPlateStatus)((Object)state.method_11654(STATUS));
                    if (status != WarpPlateStatus.WARPING) break block4;
                    for (int i2 = 0; i2 < 50; ++i2) {
                        world.method_8406((class_2394)class_2398.field_22248, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random() * 2.0, (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
                        world.method_8406((class_2394)class_2398.field_11214, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random() * 2.0, (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
                    }
                    break block5;
                }
                if (status != WarpPlateStatus.WARPING_INVALID) break block6;
                for (int i3 = 0; i3 < 10; ++i3) {
                    world.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + Math.random(), (double)pos.method_10264(), (double)pos.method_10260() + Math.random(), 0.0, (double)0.01f, 0.0);
                }
                break block5;
            }
            if (status != WarpPlateStatus.ATTUNING) break block5;
            for (i = 0; i < 10; ++i) {
                world.method_8406((class_2394)class_2398.field_22249, (double)pos.method_10263() + Math.random(), (double)pos.method_10264(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 10; ++i) {
                world.method_8406((class_2394)class_2398.field_22246, (double)pos.method_10263() + Math.random(), (double)pos.method_10264(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WarpPlateBlockEntity(pos, state);
    }

    @Override
    protected class_1269 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 blockHitResult) {
        if (itemStack.method_31573(ModItemTags.WARP_SHARDS)) {
            WarpPlateBlockEntity warpPlate;
            class_1799 existing;
            class_2586 class_25862;
            if (!level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof WarpPlateBlockEntity && (existing = (warpPlate = (WarpPlateBlockEntity)class_25862).getShardItem()).method_7960()) {
                warpPlate.setShardItem(player.method_31549().field_7477 ? itemStack.method_7972().method_7971(1) : itemStack.method_7971(1));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 blockHitResult) {
        if (player.method_5715()) {
            WarpPlateBlockEntity warpPlate;
            class_1799 itemStack;
            class_2586 class_25862;
            if (!level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof WarpPlateBlockEntity && !(itemStack = (warpPlate = (WarpPlateBlockEntity)class_25862).getShardItem()).method_7960()) {
                class_1542 itemEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                level.method_8649((class_1297)itemEntity);
                warpPlate.setShardItem(class_1799.field_8037);
            }
            return class_1269.field_5812;
        }
        class_2586 class_25863 = level.method_8321(pos);
        if (class_25863 instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)class_25863;
            warpPlate.getSettingsMenuProvider().ifPresent(it -> Balm.getNetworking().openMenu(player, it));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static class_124 getColorForName(String name) {
        int colorIndex = Math.abs(name.hashCode()) % 15;
        class_124 textFormatting = class_124.method_534((int)colorIndex);
        if (textFormatting == class_124.field_1080) {
            return class_124.field_1076;
        }
        if (textFormatting == class_124.field_1063) {
            return class_124.field_1064;
        }
        if (textFormatting == class_124.field_1074) {
            return class_124.field_1065;
        }
        return textFormatting != null ? textFormatting : class_124.field_1080;
    }

    public static String getGalacticIdentifier(UUID waystoneUid) {
        String intermediate = waystoneUid.toString().replaceAll("[0-9\\-]", "");
        return intermediate.substring(0, Math.min(8, intermediate.length()));
    }

    public static class_2561 getGalacticName(UUID waystoneUid) {
        String name = WarpPlateBlock.getGalacticIdentifier(waystoneUid);
        return class_2561.method_43470((String)name).method_27692(WarpPlateBlock.getColorForName(name)).method_27696(GALACTIC_STYLE);
    }

    @Override
    protected boolean shouldOpenMenuWhenPlaced() {
        return false;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        class_2591 tickingBlockEntityType = (class_2591)ModBlockEntities.warpPlate.get();
        if (tickingBlockEntityType == null) {
            return null;
        }
        return world.field_9236 ? null : WarpPlateBlock.method_31618(type, (class_2591)tickingBlockEntityType, (level, pos, state2, blockEntity) -> blockEntity.serverTick());
    }

    public static enum WarpPlateStatus implements class_3542
    {
        EMPTY,
        IDLE,
        ATTUNING,
        WARPING,
        WARPING_INVALID,
        LOCKED;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

