/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mes.misc.structurepiececounter;

import com.finndog.mes.MESCommon;
import com.finndog.mes.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.finndog.mes.misc.structurepiececounter.StructurePieceCountsObj;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_6328;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends class_4309<JsonElement> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final StructurePieceCountsManager STRUCTURE_PIECE_COUNTS_MANAGER = new StructurePieceCountsManager();
    private Map<class_2960, List<StructurePieceCountsObj>> StructureToPieceCountsObjs = new HashMap<class_2960, List<StructurePieceCountsObj>>();
    private final Map<class_2960, Map<class_2960, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<class_2960, Map<class_2960, RequiredPieceNeeds>>();
    private final Map<class_2960, Map<class_2960, Integer>> cachedMaxCountPiecesMap = new HashMap<class_2960, Map<class_2960, Integer>>();

    public StructurePieceCountsManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"mes_pieces_spawn_counts"));
    }

    @class_6328
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(class_2960 fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(this){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany == null || entry.neverSpawnMoreThanThisMany == null || entry.alwaysSpawnThisMany <= entry.neverSpawnMoreThanThisMany) continue;
            throw new Exception("Moog's End Structures Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
        }
        return piecesSpawnCounts;
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, List<StructurePieceCountsObj>> mapBuilder = new HashMap<class_2960, List<StructurePieceCountsObj>>();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                mapBuilder.put((class_2960)fileIdentifier, this.getStructurePieceCountsObjs((class_2960)fileIdentifier, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MESCommon.LOGGER.error("Moog's End Structures Error: Couldn't parse mes_pieces_spawn_counts file {} - JSON looks like: {}", fileIdentifier, jsonElement, (Object)e);
            }
        });
        this.StructureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(manager);
    }

    public void parseAndAddCountsJSONObj(class_2960 structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.StructureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MESCommon.LOGGER.error("Moog's End Structures Error: Couldn't parse mes_pieces_spawn_counts file {} - JSON looks like: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<class_2960, RequiredPieceNeeds> getRequirePieces(class_2960 structureRL) {
        if (!this.StructureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<class_2960, RequiredPieceNeeds> requirePiecesMap = new HashMap<class_2960, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.alwaysSpawnThisMany != null) {
                    requirePiecesMap.put(class_2960.method_12829((String)entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
                }
            });
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @class_6328
    public Map<class_2960, Integer> getMaximumCountForPieces(class_2960 structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<class_2960, Integer> maxCountPiecesMap = new HashMap<class_2960, Integer>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.neverSpawnMoreThanThisMany != null) {
                    maxCountPiecesMap.put(class_2960.method_12829((String)entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
                }
            });
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

