/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import fuzs.visualworkbench.world.level.block.entity.WorkbenchVisualsProvider;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_916;
import net.minecraft.class_918;
import org.joml.Quaternionfc;

public class CraftingTableBlockEntityRenderer<T extends class_2586 & WorkbenchVisualsProvider>
implements class_827<T> {
    private final class_10444 itemStackRenderState = new class_10444();
    private final class_918 itemRenderer;
    public final class_10442 itemModelResolver;

    public CraftingTableBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
        this.itemModelResolver = context.method_65558();
    }

    public void method_3569(T blockEntity, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, int packedOverlay, class_243 cameraPosition) {
        class_1937 level = blockEntity.method_10997();
        if (level != null) {
            int packedLightAbove = class_761.method_23794((class_1920)level, (class_2338)blockEntity.method_11016().method_10084());
            for (int i = 0; i < ((class_1263)blockEntity).method_5439(); ++i) {
                class_1799 itemStack = ((class_1263)blockEntity).method_5438(i);
                if (itemStack.method_7960()) continue;
                this.renderIngredientItem(blockEntity, level, partialTick, poseStack, multiBufferSource, packedLightAbove, packedOverlay, i, itemStack);
            }
            class_1799 itemStack = ((WorkbenchVisualsProvider)blockEntity).getCraftingResult();
            if (!itemStack.method_7960()) {
                this.renderResultItem(itemStack, level, (float)((WorkbenchVisualsProvider)blockEntity).getAnimationController().renderState().ticks + partialTick, poseStack, multiBufferSource, packedLightAbove, packedOverlay);
            }
        }
    }

    private void renderIngredientItem(T blockEntity, class_1937 level, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, int packedOverlay, int i, class_1799 itemStack) {
        this.itemModelResolver.method_65598(this.itemStackRenderState, itemStack, class_811.field_4318, level, null, 0);
        poseStack.method_22903();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).flatRendering) {
            this.setupFlatRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController().renderState(), CraftingTableBlockEntityRenderer.isGui3d(this.itemStackRenderState), partialTick, poseStack, i);
        } else {
            this.setupFloatingRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController().renderState(), CraftingTableBlockEntityRenderer.isGui3d(this.itemStackRenderState), partialTick, poseStack, i);
        }
        this.itemRenderer.method_23178(itemStack, class_811.field_4319, packedLight, packedOverlay, poseStack, multiBufferSource, blockEntity.method_10997(), (int)blockEntity.method_11016().method_10063() + i);
        poseStack.method_22909();
    }

    private void setupFloatingRenderer(CraftingTableAnimationController.RenderState renderState, boolean isBlockItem, float partialTick, class_4587 poseStack, int index) {
        float shift = (float)Math.abs(((double)((float)renderState.ticks + partialTick) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        poseStack.method_22904(0.5, (double)shift, 0.5);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)renderState.currentAngle, (float)renderState.nextAngle)));
        poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        float scale = isBlockItem ? 0.24f : 0.18f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void setupFlatRenderer(CraftingTableAnimationController.RenderState renderState, boolean isBlockItem, float partialTick, class_4587 poseStack, int index) {
        poseStack.method_22904(0.5, 0.0, 0.5);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)renderState.currentAngle, (float)renderState.nextAngle)));
        poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, isBlockItem ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
        float scale = isBlockItem ? 0.25f : 0.175f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void renderResultItem(class_1799 itemStack, class_1937 level, float time, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (!((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).renderResult) {
            return;
        }
        this.itemModelResolver.method_65598(this.itemStackRenderState, itemStack, class_811.field_4318, level, null, 0);
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 1.15f, 0.5f);
        float hoverOffset = class_3532.method_15374((float)(time / 10.0f)) * 0.04f + 0.1f;
        class_238 aABB = class_916.method_67985((class_10444)this.itemStackRenderState);
        float modelYScale = -((float)aABB.field_1322) + 0.0625f;
        poseStack.method_22904(0.0, (double)(hoverOffset + modelYScale), 0.0);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(time / 20.0f));
        if (!CraftingTableBlockEntityRenderer.isGui3d(this.itemStackRenderState)) {
            poseStack.method_22905(0.75f, 0.75f, 0.75f);
        }
        this.itemStackRenderState.method_65604(poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.method_22909();
    }

    static boolean isGui3d(class_10444 renderState) {
        return class_916.method_67985((class_10444)renderState).method_17941() > 0.0625;
    }
}

