/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.client.gui.screens.inventory.ModAnvilScreen;
import fuzs.easyanvils.client.gui.screens.inventory.NameTagEditScreen;
import fuzs.easyanvils.client.handler.BlockStateTranslator;
import fuzs.easyanvils.client.renderer.blockentity.AnvilRenderer;
import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.event.v1.ClientLifecycleEvents;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ItemTooltipRegistry;
import fuzs.puzzleslib.api.client.renderer.v1.RenderTypeHelper;
import fuzs.puzzleslib.api.client.renderer.v1.model.ModelLoadingHelper;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.class_1087;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3300;
import net.minecraft.class_3917;

public class EasyAnvilsClient
implements ClientModConstructor {
    public void onConstructMod() {
        EasyAnvilsClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ClientLifecycleEvents.STARTED.register(minecraft -> {
            for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
                class_1921 renderType = RenderTypeHelper.getRenderType((class_2248)((class_2248)entry.getKey()));
                RenderTypeHelper.registerRenderType((class_2248)((class_2248)entry.getValue()), (class_1921)renderType);
            }
        });
    }

    public void onClientSetup() {
        ItemTooltipRegistry.registerItemTooltip((class_1935)class_1802.field_8448, (item, itemStack, tooltipContext, tooltipFlag, tooltipLineConsumer) -> {
            if (!((ClientConfig)EasyAnvils.CONFIG.get(ClientConfig.class)).nameTagTooltip) {
                return;
            }
            if (!EasyAnvils.CONFIG.getHolder(ServerConfig.class).isAvailable() || !((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.editNameTagsNoAnvil) {
                return;
            }
            tooltipLineConsumer.accept(NameTagEditScreen.DESCRIPTION_COMPONENT);
        });
    }

    public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
        BlockConversionHandler.getBlockConversions().forEach((oldBlock, newBlock) -> context.registerBlockStateResolver(newBlock, (resourceManager, executor) -> ModelLoadingHelper.loadBlockState((class_3300)resourceManager, (class_2248)oldBlock, (Executor)executor), (loadedModels, blockStateConsumer) -> {
            Map<class_2680, class_2680> blockStates = BlockStateTranslator.INSTANCE.convertAllBlockStates((class_2248)newBlock, (class_2248)oldBlock);
            for (class_2680 blockState : newBlock.method_9595().method_11662()) {
                class_1087.class_9979 model = (class_1087.class_9979)loadedModels.comp_3063().get(blockStates.get(blockState));
                if (model != null) {
                    blockStateConsumer.accept(blockState, model);
                    continue;
                }
                EasyAnvils.LOGGER.warn("Missing model for variant: '{}'", (Object)blockState);
                blockStateConsumer.accept(blockState, ModelLoadingHelper.missingModel());
            }
        }));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((class_3917)ModRegistry.ANVIL_MENU_TYPE.comp_349(), ModAnvilScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((class_2591)ModRegistry.ANVIL_BLOCK_ENTITY_TYPE.comp_349(), AnvilRenderer::new);
    }
}

