/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.jsonc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsoncObject
implements JsoncElement {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private String comment = "";
    private final Map<String, JsoncElement> elements = new LinkedHashMap<String, JsoncElement>();

    public JsoncObject add(String key, JsoncElement element) {
        this.elements.put(key, element);
        return this;
    }

    public JsoncObject remove(String key) {
        this.elements.remove(key);
        return this;
    }

    @Override
    public String toString(int indentation) {
        if (this.elements.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{\n");
        for (Map.Entry<String, JsoncElement> entry : this.elements.entrySet()) {
            JsoncElement.writeComment(builder, entry.getValue(), indentation + 1);
            builder.append(INDENT.repeat(indentation + 1));
            builder.append("\"").append(entry.getKey()).append("\": ");
            builder.append(entry.getValue().toString(indentation + 1));
            builder.append(",\n");
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append(INDENT.repeat(indentation)).append("}");
        return builder.toString();
    }

    @Override
    public void comment(String comment) {
        this.comment = comment;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public String toString() {
        return this.toString(0);
    }

    public static JsonObject parse(String json) {
        ArrayList<String> parsed = new ArrayList<String>();
        boolean inMultiLineComment = false;
        for (String line : json.split("\n")) {
            int singleLineCommentIndex = line.indexOf("//");
            if (singleLineCommentIndex != -1 && line.substring(0, singleLineCommentIndex).isBlank()) continue;
            int multiLineCommentStartIndex = line.indexOf("/*");
            if (multiLineCommentStartIndex != -1 && line.substring(0, multiLineCommentStartIndex).isBlank()) {
                inMultiLineComment = true;
            }
            if (line.lastIndexOf("*/") != -1 && inMultiLineComment) {
                inMultiLineComment = false;
                continue;
            }
            if (inMultiLineComment) continue;
            parsed.add(line);
        }
        return (JsonObject)GSON.fromJson(String.join((CharSequence)"\n", parsed), JsonObject.class);
    }
}

