/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ColorOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbColor;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbState;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.RecentColorStorage;
import com.teamresourceful.resourcefulconfig.client.utils.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class PresetsSelector
extends BaseWidget {
    private static final List<HsbColor> MINECRAFT_COLORS = List.of(HsbColor.fromRgb(-43691), HsbColor.fromRgb(-22016), HsbColor.fromRgb(-171), HsbColor.fromRgb(-11141291), HsbColor.fromRgb(0x55FFFF), HsbColor.fromRgb(-11184641), HsbColor.fromRgb(-43521), HsbColor.fromRgb(-1), HsbColor.fromRgb(-5592406), HsbColor.fromRgb(-5636096), HsbColor.fromRgb(-16733696), HsbColor.fromRgb(-16733526), HsbColor.fromRgb(-16777046), HsbColor.fromRgb(-5635926), HsbColor.fromRgb(-11184811), HsbColor.fromRgb(-16777216));
    private final int[] presets;
    private final State<ColorOptionWidget.PresetType> type;
    private final HsbState state;
    private final boolean withAlpha;
    private Collection<HsbColor> colors = new ArrayList<HsbColor>();
    private ColorOptionWidget.PresetType lastType;

    public PresetsSelector(int width, int[] presets, State<ColorOptionWidget.PresetType> type, HsbState state, boolean withAlpha) {
        super(width, width / 8 * 2 + 4);
        this.presets = presets;
        this.type = type;
        this.state = state;
        this.getColors();
        this.withAlpha = withAlpha;
    }

    private Collection<HsbColor> getColors() {
        if (this.lastType != this.type.get()) {
            this.colors = switch ((ColorOptionWidget.PresetType)this.type.get()) {
                default -> throw new MatchException(null, null);
                case ColorOptionWidget.PresetType.DEFAULTS -> {
                    ArrayList<HsbColor> colors = new ArrayList<HsbColor>();
                    for (int preset : this.presets) {
                        int color = this.withAlpha ? preset : preset | 0xFF000000;
                        colors.add(HsbColor.fromRgb(color));
                    }
                    yield colors;
                }
                case ColorOptionWidget.PresetType.RECENTS -> RecentColorStorage.getRecentColors(this.withAlpha);
                case ColorOptionWidget.PresetType.MC_COLORS -> MINECRAFT_COLORS;
            };
            this.lastType = (ColorOptionWidget.PresetType)this.type.get();
        }
        return this.colors;
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_52706(class_1921::method_62277, ModSprites.ACCENT, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        graphics.method_52706(class_1921::method_62277, ModSprites.BUTTON, this.method_46426() + 1, this.method_46426() + 1, this.method_25368() - 2, this.method_25364() - 2);
        int size = (this.method_25368() - 18) / 8;
        int i = 0;
        for (HsbColor color : this.getColors()) {
            if (i >= 16) break;
            int j = i % 8;
            int k = i / 8;
            int x = this.method_46426() + 3 + j * size + 2 * j;
            int y = this.method_46427() + 3 + k * size + 2 * k;
            int rgba = color.toRgba();
            graphics.method_25294(x, y, x + size, y + size, rgba);
            graphics.method_49601(x, y, size, size, -2236963);
            if (mouseX >= x && mouseX <= x + size && mouseY >= y && mouseY <= y + size) {
                graphics.method_49601(x, y, size, size, -16777216);
                class_437 screen = class_310.method_1551().field_1755;
                if (screen != null) {
                    if (!this.withAlpha) {
                        rgba &= 0xFFFFFF;
                    }
                    class_5250 text = class_2561.method_43470((String)"[").method_54663(rgba | 0xFF000000).method_10852((class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "#%06X", rgba)).method_54663(-1)).method_10852((class_2561)class_2561.method_43470((String)"]")).method_54663(rgba | 0xFF000000);
                    screen.method_47415((class_2561)text);
                }
            }
            ++i;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int size = (this.method_25368() - 18) / 8;
        int i = 0;
        for (HsbColor color : this.getColors()) {
            if (i >= 16) break;
            int j = i % 8;
            int k = i / 8;
            int x = this.method_46426() + 3 + j * size + 2 * j;
            int y = this.method_46427() + 3 + k * size + 2 * k;
            if (mouseX >= (double)x && mouseX <= (double)(x + size) && mouseY >= (double)y && mouseY <= (double)(y + size)) {
                RecentColorStorage.add(this.state.get());
                this.lastType = null;
                this.state.set(color);
                return true;
            }
            ++i;
        }
        return false;
    }
}

