/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.network.message.client;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.network.message.NetworkMessageRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SyncMobCaptureCardDefinitionsMessage(Map<class_2960, MobCaptureCardDefinition> definitions) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_mob_farm", (String)"sync_mob_capture_card_definitions");
    public static final class_8710.class_9154<SyncMobCaptureCardDefinitionsMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, SyncMobCaptureCardDefinitionsMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), SyncMobCaptureCardDefinitionsMessage::create);

    public static SyncMobCaptureCardDefinitionsMessage create(class_2540 buffer) {
        int size = buffer.method_10816();
        HashMap<class_2960, MobCaptureCardDefinition> definitions = new HashMap<class_2960, MobCaptureCardDefinition>();
        for (int i = 0; i < size; ++i) {
            class_2960 entityId = buffer.method_10810();
            MobCaptureCardDefinition definition = MobCaptureCardDefinition.decode(buffer);
            definitions.put(entityId, definition);
        }
        return new SyncMobCaptureCardDefinitionsMessage(definitions);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(this.definitions.size());
        for (Map.Entry<class_2960, MobCaptureCardDefinition> entry : this.definitions.entrySet()) {
            buffer.method_10812(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<SyncMobCaptureCardDefinitionsMessage> method_56479() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleClient() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            log.warn("No mob capture card definitions to sync!");
            return;
        }
        log.info("Syncing {} mob capture card definitions to client.", (Object)this.definitions.size());
        MobCaptureCardDefinitionManager.setDefinitions(this.definitions);
    }
}

