/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobCatcherConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_10289;
import net.minecraft.class_1863;
import net.minecraft.class_2596;
import net.minecraft.class_2788;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRecipeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Recipe Manager]";
    private static final String MOB_CAPTURE_PREFIX = "mob_catcher/";

    private ModRecipeManager() {
    }

    public static void register(MinecraftServer minecraftServer) {
        log.info("{} Mod Recipe Manager ...", (Object)"Register Easy Mob Farm");
        ArrayList recipes = new ArrayList(minecraftServer.method_3772().method_8126());
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.ENDURING_CAPTURE_NET_ENABLED, "enduring_capture_net");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.IRONBOUND_CONTAINMENT_CAGE_ENABLED, "ironbound_containment_cage");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.MYSTIC_BINDING_CRYSTAL_ENABLED, "mystic_binding_crystal");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.VOID_BINDING_CHAIN_ENABLED, "void_binding_chain");
        if (minecraftServer.method_3772().method_8126().size() != recipes.size()) {
            log.info("Updating recipes with adjusted recipes ...");
            class_10289 recipeMap = class_10289.method_64700(recipes);
            ModRecipeManager.setRecipes(minecraftServer.method_3772(), recipeMap);
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                log.info("{} Sync recipe to player {} ...", (Object)LOG_PREFIX, (Object)player.method_5477().getString());
                player.field_13987.method_14364((class_2596)new class_2788(minecraftServer.method_3772().method_64692(), minecraftServer.method_3772().method_64694()));
            }
            minecraftServer.method_3772().method_8126().forEach(recipeHolder -> log.debug("{} Loaded recipe: {}", (Object)LOG_PREFIX, (Object)recipeHolder.comp_1932()));
        }
    }

    private static void setRecipes(class_1863 recipeManager, class_10289 recipeMap) {
        String[] possibleFieldNames;
        for (String fieldName : possibleFieldNames = new String[]{"recipes", "f_346395_", "field_54638", "preparedRecipes"}) {
            try {
                Field recipesField = class_1863.class.getDeclaredField(fieldName);
                recipesField.setAccessible(true);
                recipesField.set(recipeManager, recipeMap);
                log.info("{} Updated recipe map using field '{}'!", (Object)LOG_PREFIX, (Object)fieldName);
                return;
            }
            catch (NoSuchFieldException e) {
                log.debug("{} Field '{}' not found, trying next...", (Object)LOG_PREFIX, (Object)fieldName);
            }
            catch (IllegalAccessException e) {
                log.error("{} Failed to set recipe map for field '{}'!", (Object)LOG_PREFIX, (Object)fieldName, (Object)e);
                return;
            }
        }
        log.error("{} Failed to update recipe map! No valid field names found.", (Object)LOG_PREFIX);
    }

    private static boolean removeRecipeIfDisabled(Collection<class_8786<?>> recipes, boolean isEnabled, String itemId) {
        if (isEnabled) {
            return false;
        }
        String recipeLocation = "easy_mob_farm:mob_catcher/" + itemId;
        boolean removed = recipes.removeIf(recipeHolder -> recipeHolder.comp_1932().method_29177().toString().equals(recipeLocation));
        if (removed) {
            log.info("{} Removed {} recipe ...", (Object)LOG_PREFIX, (Object)recipeLocation);
        } else {
            log.error("{} Failed to deactivate recipe {} !", (Object)LOG_PREFIX, (Object)recipeLocation);
        }
        return removed;
    }
}

