/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.experience;

import java.lang.reflect.Method;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ExperienceManagerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    default public int getExperienceReward(class_1309 livingEntity, class_3218 serverLevel) {
        return this.getExperienceReward(livingEntity, serverLevel, null);
    }

    default public boolean shouldDropExperience(class_1309 livingEntity) {
        try {
            return livingEntity.method_6054();
        }
        catch (Exception e) {
            log.error("{} Failed to check if entity should drop experience for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    default public int getExperienceReward(class_1309 livingEntity, class_3218 serverLevel, String methodName) {
        try {
            Method getBaseExperienceRewardMethod = class_1309.class.getDeclaredMethod("getBaseExperienceReward", class_3218.class);
            getBaseExperienceRewardMethod.setAccessible(true);
            return (Integer)getBaseExperienceRewardMethod.invoke((Object)livingEntity, serverLevel);
        }
        catch (NoSuchMethodException e) {
            if (methodName != null && !methodName.isEmpty()) {
                try {
                    Method getBaseExperienceRewardMethod = class_1309.class.getDeclaredMethod(methodName, class_3218.class);
                    getBaseExperienceRewardMethod.setAccessible(true);
                    return (Integer)getBaseExperienceRewardMethod.invoke((Object)livingEntity, serverLevel);
                }
                catch (Exception ex) {
                    log.error("{} Failed to get experience reward for {} with method {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)methodName, (Object)ex);
                }
            } else {
                log.error("{} Failed to get experience reward for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            }
        }
        catch (Exception e) {
            log.error("{} Failed to get experience reward for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            return 0;
        }
        log.error("{} Failed to get experience reward for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName());
        return 0;
    }
}

