/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.entity;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardConfig;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingEntityEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random RANDOM = new Random();

    private LivingEntityEvents() {
    }

    public static void handleLivingEntityDeathEvent(class_1309 livingEntity, class_1282 damageSource) {
        class_1937 class_19372;
        if (!MobCaptureCardConfig.dropMobCaptureCardOnKill) {
            return;
        }
        if (MobCaptureCardConfig.requirePlayerKill && (damageSource.method_5529() == null || !(damageSource.method_5529() instanceof class_1657))) {
            return;
        }
        String entityName = class_7923.field_41177.method_10221((Object)livingEntity.method_5864()).toString();
        if (MobCaptureCardConfig.mobCaptureCardKillDropDenyList.contains(entityName) || !MobCaptureCardConfig.mobCaptureCardKillDropAllowList.isEmpty() && !MobCaptureCardConfig.mobCaptureCardKillDropAllowList.contains(entityName)) {
            log.debug("[Skip] Mob capture card kill drop for {}.", (Object)entityName);
            return;
        }
        if (MobCaptureCardConfig.mobCaptureCardKillDropChance > 0.0f && RANDOM.nextFloat() > MobCaptureCardConfig.mobCaptureCardKillDropChance) {
            return;
        }
        class_1799 itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        if (itemStack != null && (class_19372 = livingEntity.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            log.debug("Dropped mob capture card {} for {}.", (Object)itemStack, (Object)livingEntity);
            livingEntity.method_5699(serverLevel, itemStack, 0.5f);
        } else {
            log.error("Failed to drop mob capture card for {}.", (Object)livingEntity);
        }
    }
}

