/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import org.apache.commons.lang3.StringUtils;

public class WaypointParser {
    public static String[] QUOTES = new String[]{"'", "\""};
    public static Pattern PATTERN = Pattern.compile("(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+)", 2);
    private static Pattern TEXT_BETWEEN_QUOTES = Pattern.compile("\".*?\"|'.*?'|`.*`");

    public static List<String> getWaypointStrings(String line) {
        ArrayList<Object> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                if (!PATTERN.matcher(candidate).find() || WaypointParser.parse(candidate) == null) continue;
                if (list == null) {
                    list = new ArrayList(1);
                }
                list.add("[" + candidate + "]");
            }
        }
        if (list == null && line.startsWith("xaero-waypoint:")) {
            list = new ArrayList<Object>(1);
            list.add(line);
        }
        return list;
    }

    static List<Waypoint> getWaypoints(String line) {
        ArrayList<Waypoint> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                Waypoint waypoint;
                if (!PATTERN.matcher(candidate).find() || (waypoint = WaypointParser.parse(candidate)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Waypoint>(1);
                }
                list.add(waypoint);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        ParsedWaypoint wp = ParsedWaypoint.parse(original);
        String name = wp.name;
        String dim = wp.dim;
        if (wp.x != null && wp.z != null) {
            if (name == null) {
                name = String.format("%s,%s", wp.x, wp.z);
            }
            if (dim == null) {
                dim = class_310.method_1551() == null ? "minecraft:overworld" : DimensionHelper.getDimKeyName((class_5321<class_1937>)class_310.method_1551().field_1687.method_27983());
            }
            return WaypointFactoryImpl.createWaypoint("journeymap", new class_2338(wp.x.intValue(), wp.y, wp.z.intValue()), name, dim, wp.showDeviation);
        }
        return null;
    }

    public static class_2561 parseChatForWaypoints(class_2561 component) {
        List<String> matches = WaypointParser.getWaypointStrings(component.getString());
        class_5250 response = null;
        if (matches != null) {
            boolean changed = false;
            class_7417 class_74172 = component.method_10851();
            if (class_74172 instanceof class_2588) {
                String[] strings;
                class_2588 contents = (class_2588)class_74172;
                Object[] formatArgs = contents.method_11023();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    class_2561 result;
                    Object arg;
                    if (formatArgs[i] instanceof class_2561) {
                        arg = (class_2561)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.getString(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    response = class_2561.method_43469((String)contents.method_11022(), (Object[])formatArgs);
                } else if (!matches.isEmpty() && (strings = component.getString().split(":")).length > 1) {
                    class_2561 result = WaypointParser.addWaypointMarkup(matches.getFirst(), matches);
                    response = class_2561.method_43469((String)"chat.type.text", (Object[])new Object[]{strings[0], result});
                }
            } else if (component instanceof class_5250) {
                class_5250 mutableComponent = (class_5250)component;
                for (class_2561 content : mutableComponent.method_10855()) {
                    class_2561 result = WaypointParser.addWaypointMarkup(content.getString(), matches);
                    if (result == null) continue;
                    response = result;
                    changed = true;
                }
                if (response != null) {
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in ITextComponent " + String.valueOf(component.getClass()));
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s\n%s", component.getClass(), component.getString(), class_2561.class_2562.method_10867((class_2561)component, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349())));
            }
            return response;
        }
        return component;
    }

    /*
     * WARNING - void declaration
     */
    private static class_2561 addWaypointMarkup(String text, List<String> matches) {
        ArrayList<class_5250> newParts = new ArrayList<class_5250>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator = matches.iterator();
        while (iterator.hasNext()) {
            void var8_9;
            String match = iterator.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(Constants.getStringTextComponent(text.substring(index, start)));
            }
            matched = true;
            String string = ParsedWaypoint.parse((String)match).name;
            if (string == null) {
                String string2 = match;
            }
            class_5250 clickable = Constants.getStringTextComponent(Constants.getString("jm.waypoint.chat_share") + " \u00a7b\u00a7n" + (String)var8_9 + "\u00a7r");
            clickable.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/jm wpedit " + match)));
            class_5250 hover = class_2561.method_43471((String)"jm.common.share.chat.journeymap");
            hover.method_27694(style -> style.method_27703(class_5251.method_27718((class_124)class_124.field_1054)));
            class_5250 hover2 = class_2561.method_43471((String)"jm.common.share.chat.description");
            hover2.method_27694(style -> style.method_27703(class_5251.method_27718((class_124)class_124.field_1075)));
            hover.method_10852((class_2561)hover2);
            clickable.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)hover)));
            newParts.add(clickable);
            index = start + match.length();
            iterator.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(Constants.getStringTextComponent(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            class_5250 replacement = Constants.getStringTextComponent("");
            for (class_2561 class_25612 : newParts) {
                replacement.method_10852(class_25612);
            }
            return replacement;
        }
        return null;
    }

    public record ParsedWaypoint(String name, String dim, Integer x, int y, Integer z, boolean showDeviation) {
        static String xaerosDimParser(String dim) {
            if ("overworld".equals(dim = ((String)dim).replace("Internal-", "").replace("-waypoints", "").replace("dim%", "").replace("$", ":")) || "the-nether".equals(dim) || "the-end".equals(dim)) {
                dim = "minecraft:" + (String)dim;
            }
            if ("External".equals(dim)) {
                dim = "minecraft:overworld";
            }
            dim = ((String)dim).replace("-", "_");
            return dim;
        }

        public static ParsedWaypoint parse(String string) {
            Object name = null;
            String raw = string.replaceAll("[\\[\\]]", "");
            if (string.startsWith("xaero-waypoint:")) {
                String[] split = string.split(":");
                String dimName = ParsedWaypoint.xaerosDimParser(split[9]);
                name = split[1].replace("gui.", "");
                int x = Integer.parseInt(split[3]);
                int y = Integer.parseInt(split[4].replace("~", "63"));
                int z = Integer.parseInt(split[5]);
                return new ParsedWaypoint((String)name, dimName, x, y, z, false);
            }
            String[] nameMatch = StringUtils.substringsBetween((String)string, (String)"\"", (String)"\"");
            if (nameMatch != null && nameMatch.length > 0) {
                name = nameMatch[0];
            }
            Integer x = null;
            int y = 63;
            Integer z = null;
            Object dim = "minecraft:overworld";
            boolean showDeviation = false;
            for (String part : raw.split(",")) {
                String[] prop;
                if (!part.contains(":") || (prop = part.split(":")).length != 2 && (prop.length != 3 || !part.contains("dim:"))) continue;
                String key = prop[0].trim().toLowerCase();
                String val = prop[1].trim();
                try {
                    if ("x".equals(key)) {
                        x = Integer.parseInt(val);
                    } else if ("y".equals(key)) {
                        y = Integer.parseInt(val);
                    } else if ("z".equals(key)) {
                        z = Integer.parseInt(val);
                    } else if ("dim".equals(key)) {
                        dim = val + ":" + prop[2].trim();
                    } else if ("name".equals(key) && name == null) {
                        name = val.replace("\"", "");
                    }
                    if (!"showDeviation".equals(key)) continue;
                    showDeviation = Boolean.parseBoolean(val);
                }
                catch (Exception e) {
                    Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + String.valueOf(e));
                }
            }
            if (name == null) {
                name = x + "," + z;
            }
            return new ParsedWaypoint((String)name, (String)dim, x, y, z, showDeviation);
        }
    }
}

