/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.util.List;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.client.Constants;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.buttons.BooleanPropertyButton;
import journeymap.client.ui.theme.Theme;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5481;

public class ThemeButton
extends BooleanPropertyButton
implements IThemeButton {
    protected Theme theme;
    protected Theme.Control.ButtonSpec buttonSpec;
    protected class_1043 textureOn;
    protected class_1043 textureHover;
    protected class_1043 textureOff;
    protected class_1043 textureDisabled;
    protected class_1043 textureIcon;
    protected String iconName;
    protected class_2960 icon;
    protected List<class_5481> additionalTooltips;
    protected boolean staysOn;
    private boolean displayClickToggle = true;

    public void setDisplayClickToggle(boolean displayClickToggle) {
        this.displayClickToggle = displayClickToggle;
    }

    public ThemeButton(Theme theme, String rawLabel, String iconName, class_4185.class_4241 onPress) {
        this(theme, Constants.getString(rawLabel), Constants.getString(rawLabel), false, iconName, onPress);
    }

    public ThemeButton(Theme theme, String rawLabel, class_2960 icon, class_4185.class_4241 onPress) {
        super(Constants.getString(rawLabel), Constants.getString(rawLabel), null, onPress);
        this.icon = icon;
        this.setToggled(this.toggled);
        this.updateTheme(theme);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, boolean toggled, String iconName, class_4185.class_4241 onPress) {
        super(Constants.getString(labelOn), Constants.getString(labelOff), null, onPress);
        this.iconName = iconName;
        this.setToggled(toggled);
        this.updateTheme(theme);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, String iconName, BooleanField field, class_4185.class_4241 onPress) {
        super(Constants.getString(labelOn), Constants.getString(labelOff), field, onPress);
        this.iconName = iconName;
        this.updateTheme(theme);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, class_2960 icon, BooleanField field, class_4185.class_4241 onPress) {
        super(Constants.getString(labelOn), Constants.getString(labelOff), field, onPress);
        this.icon = icon;
        this.updateTheme(theme);
    }

    public boolean isStaysOn() {
        return this.staysOn;
    }

    public void setStaysOn(boolean staysOn) {
        this.staysOn = staysOn;
    }

    public void updateTheme(Theme theme) {
        this.theme = theme;
        this.buttonSpec = this.getButtonSpec(theme);
        if (this.buttonSpec.useThemeImages) {
            String pattern = this.getPathPattern();
            String prefix = this.buttonSpec.prefix;
            this.textureOn = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "on"));
            this.textureOff = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "off"));
            this.textureHover = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "hover"));
            this.textureDisabled = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "disabled"));
        } else {
            this.textureOn = null;
            this.textureOff = null;
            this.textureHover = null;
            this.textureDisabled = null;
        }
        this.textureIcon = this.icon != null ? TextureCache.getThemeTextureFromResource(this.icon) : TextureCache.getThemeTexture(theme, String.format("icon/%s.png", this.iconName));
        this.method_25358(this.buttonSpec.width);
        this.method_53533(this.buttonSpec.height);
        this.setToggled(false, false);
    }

    public boolean hasValidTextures() {
        if (this.buttonSpec.useThemeImages) {
            return ((TextureAccess)this.textureOn).journeymap$hasImage() && ((TextureAccess)this.textureOff).journeymap$hasImage();
        }
        return this.textureIcon != null && ((TextureAccess)this.textureIcon).journeymap$hasImage();
    }

    protected String getPathPattern() {
        return "control/%sbutton_%s.png";
    }

    protected Theme.Control.ButtonSpec getButtonSpec(Theme theme) {
        return theme.control.button;
    }

    public Theme.Control.ButtonSpec getButtonSpec() {
        return this.buttonSpec;
    }

    protected class_1043 getActiveTexture(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.textureDisabled;
        }
        return isMouseOver ? this.textureOn : this.textureOff;
    }

    protected Theme.ColorSpec getIconColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.iconDisabled;
        }
        if (isMouseOver) {
            return this.toggled != false ? this.buttonSpec.iconHoverOn : this.buttonSpec.iconHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.iconOn : this.buttonSpec.iconOff) : this.buttonSpec.iconOff;
    }

    protected Theme.ColorSpec getButtonColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.buttonDisabled;
        }
        if (isMouseOver) {
            return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonHoverOn : this.buttonSpec.buttonHoverOff) : this.buttonSpec.buttonHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonOn : this.buttonSpec.buttonOff) : this.buttonSpec.buttonOff;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float ticks) {
        if (!this.isVisible()) {
            return;
        }
        boolean hover = mouseX >= super.method_46426() && mouseY >= super.method_46427() && mouseX < super.method_46426() + this.field_22758 && mouseY < super.method_46427() + this.field_22759;
        this.setMouseOver(hover);
        class_1043 activeTexture = this.getActiveTexture(this.method_49606());
        Theme.ColorSpec iconColorSpec = this.getIconColor(this.method_49606());
        int drawX = this.method_46426();
        int drawY = this.method_46427();
        RenderWrapper.enableDepthTest();
        if (this.buttonSpec.useThemeImages) {
            Theme.ColorSpec buttonColorSpec = this.getButtonColor(this.method_49606());
            float buttonScale = 1.0f;
            if (this.buttonSpec.width != ((TextureAccess)activeTexture).journeymap$getWidth()) {
                buttonScale = 1.0f * (float)this.buttonSpec.width / (float)((TextureAccess)activeTexture).journeymap$getWidth();
            }
            DrawUtil.drawColoredTexture(graphics, activeTexture, buttonColorSpec.getColor(), buttonColorSpec.alpha, drawX, drawY, buttonScale, 0.0);
        } else {
            this.drawNativeButton(graphics, mouseX, mouseY);
        }
        class_1921 renderType = JMRenderTypes.getIcon(this.textureIcon.method_68004());
        class_4597.class_4598 buffers = ((GuiGraphicsAccessor)graphics).getBufferSource();
        class_4588 vertexBuilder = buffers.getBuffer(renderType);
        if (!this.buttonSpec.useThemeImages) {
            DrawUtil.drawQuad(graphics, vertexBuilder, 0, 1.0f, (double)drawX + 0.5, (double)drawY + 0.5, (double)this.theme.icon.width, (double)this.theme.icon.height, 0.0, false);
        }
        DrawUtil.drawQuad(graphics, vertexBuilder, iconColorSpec.getColor(), 1.0f, (double)drawX, (double)drawY, (double)this.theme.icon.width, (double)this.theme.icon.height, 0.0, false);
        buffers.method_37104();
    }

    public void drawNativeButton(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51448().method_22903();
        class_2960 buttonTex = SPRITES.method_52729(this.field_22763, this.method_25367());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.enableBlend();
        RenderWrapper.blendFunc(770, 771);
        graphics.method_52706(class_1921::method_62277, buttonTex, super.method_46426(), super.method_46427(), this.field_22758, this.field_22759);
        this.method_25403(mouseX, mouseY, 0, super.method_46426(), super.method_46427());
        graphics.method_51448().method_22909();
    }

    public void setAdditionalTooltips(List<class_5481> additionalTooltips) {
        this.additionalTooltips = additionalTooltips;
    }

    @Override
    public List<class_5481> getWrappedTooltip() {
        if (!this.field_22764) {
            return null;
        }
        List<class_5481> list = super.getWrappedTooltip();
        String styleCode = null;
        styleCode = !this.isEnabled() ? this.buttonSpec.tooltipDisabledStyle : (this.toggled != false ? this.buttonSpec.tooltipOnStyle : this.buttonSpec.tooltipOffStyle);
        class_2583 style = styleCode.isEmpty() || "".equals(styleCode) ? class_2583.field_24360 : class_2583.field_24360.method_27706(class_124.method_544((char)styleCode.charAt(1)));
        list.add(0, class_5481.method_30747((String)this.method_25369().getString(), (class_2583)style));
        if (this.additionalTooltips != null) {
            list.addAll(this.additionalTooltips);
        }
        return list;
    }

    public class_4185 getButton() {
        return this;
    }
}

