/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.about;

import com.mojang.authlib.GameProfile;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class SplashHead
extends class_339 {
    public final String name;
    public final String uuid;
    public final String title;
    public int width;
    public double moveX;
    public double moveY;
    private double moveDistance = 1.0;
    private Random r = new Random();
    protected Rectangle2D.Double bounds;

    public SplashHead(String uuid, String name, String titleKey) {
        super(20, 20, 20, 20, (class_2561)class_2561.method_43473());
        this.uuid = uuid;
        this.name = name;
        this.title = titleKey != null ? Constants.getString(titleKey) : "";
    }

    public class_1043 getSkin() {
        return TextureCache.getPlayerSkin(new GameProfile(UUID.fromString(this.uuid), this.name));
    }

    public int getWidth(class_327 fr) {
        String[] nameParts;
        this.width = fr.method_1727(this.title);
        for (String part : nameParts = this.name.trim().split(" ")) {
            this.width = Math.max(this.width, fr.method_1727(part));
        }
        return this.width;
    }

    public void method_48579(class_332 guiGraphics, int i, int i1, float v) {
        int imgY = this.method_46427() - 2;
        int imgX = this.getCenterX() - 10;
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int lineHeight = (int)(9.0 * 1.4);
        DrawUtil.drawGradientRect(guiGraphics, imgX - 1, imgY - 1, 22.0, 22.0, 0, 0.4f, 0, 0.8f);
        DrawUtil.drawTexture(guiGraphics, this.getSkin(), 0xFFFFFF, 1.0f, imgX, imgY, 20.0, 20.0, false, 0.0);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        int y = imgY + 24;
        String name = this.name.trim();
        String name2 = null;
        boolean twoLineName = name.contains(" ");
        if (twoLineName) {
            String[] parts = this.name.split(" ");
            name = parts[0];
            name2 = parts[1];
        }
        DrawUtil.drawLabel(guiGraphics, name, this.getCenterX(), y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, 1.0, true);
        y += lineHeight;
        if (name2 != null) {
            DrawUtil.drawLabel(guiGraphics, name2, this.getCenterX(), y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, 1.0, true);
            y += lineHeight;
        }
        DrawUtil.drawLabel(guiGraphics, this.title, this.getCenterX(), y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65280, 1.0f, 1.0, true);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25358(int minWidth) {
        this.width = minWidth;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void randomizeVector() {
        this.moveDistance = this.r.nextDouble() + 0.5;
        this.moveX = this.r.nextBoolean() ? this.moveDistance : -this.moveDistance;
        this.moveDistance = this.r.nextDouble() + 0.5;
        this.moveY = this.r.nextBoolean() ? this.moveDistance : -this.moveDistance;
    }

    public void adjustVector(Rectangle2D.Double screenBounds) {
        Rectangle2D.Double buttonBounds = new Rectangle2D.Double(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        if (!screenBounds.contains(buttonBounds)) {
            int xMargin = this.method_25368();
            int yMargin = this.method_25364();
            if (buttonBounds.getMinX() <= (double)xMargin) {
                this.moveX = this.moveDistance;
            } else if (buttonBounds.getMaxX() >= screenBounds.getWidth() - (double)xMargin) {
                this.moveX = -this.moveDistance;
            }
            if (buttonBounds.getMinY() <= (double)yMargin) {
                this.moveY = this.moveDistance;
            } else if (buttonBounds.getMaxY() >= screenBounds.getHeight() - (double)yMargin) {
                this.moveY = -this.moveDistance;
            }
        }
        this.continueVector();
    }

    public void continueVector() {
        int x = (int)Math.round((double)this.method_46426() + this.moveX);
        int y = (int)Math.round((double)this.method_46427() + this.moveY);
        this.method_46421(x);
        this.method_46419(y);
    }

    public void avoid(List<SplashHead> others) {
        for (SplashHead other : others) {
            if (this == other || !(this.getDistance(other) <= (double)this.method_25368())) continue;
            this.randomizeVector();
            break;
        }
    }

    public int getCenterX() {
        return super.method_46426() + this.width / 2;
    }

    protected Rectangle2D.Double updateBounds() {
        this.bounds = new Rectangle2D.Double(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        return this.bounds;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return this.updateBounds();
        }
        return this.bounds;
    }

    public int getMiddleY() {
        return super.method_46427() + this.field_22759 / 2;
    }

    public double getDistance(SplashHead other) {
        double px = this.getCenterX() - other.getCenterX();
        double py = this.getMiddleY() - other.getMiddleY();
        return Math.sqrt(px * px + py * py);
    }
}

