/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import java.util.Collection;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.buttons.RadioButton;
import journeymap.client.ui.component.widgets.RadioButtonListWidget;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ImageRadioButtonListWidget<T extends class_2960>
extends RadioButtonListWidget<T> {
    private final int textureHeight;
    private final int textureWidth;

    public ImageRadioButtonListWidget(String titleKey, Collection<T> values, T enabledValue, int textureWidth, int textureHeight, RadioButtonListWidget.OnChange<T> onChange) {
        super(titleKey, values, enabledValue, onChange);
        this.textureHeight = textureHeight;
        this.textureWidth = textureWidth;
    }

    @Override
    protected RadioButton createRadioButton(T value) {
        return new RadioButton.ImageRadioButton(8, 8, this.textureWidth, this.textureHeight, (class_2960)value, value == this.enabledValue, this::onPress);
    }

    @Override
    protected void buildButtonGrid() {
        this.buttonGrid.method_48636(1);
        this.buttonGrid.method_48635(-2);
        int row = 0;
        int column = 0;
        for (class_2960 value : this.values) {
            if (row >= 4) {
                ++column;
                ++this.columnCt;
                row = 0;
            }
            RadioButton button = this.createRadioButton((T)value);
            this.buttonValueMap.put(button, value);
            class_8667 layout = class_8667.method_52742();
            layout.method_52740().method_46474();
            layout.method_52735(-4);
            layout.method_52736((class_8021)button);
            layout.method_52736((class_8021)((RadioButton.ImageRadioButton)button).getImageWidget());
            this.buttonGrid.method_46452((class_8021)layout, row++, column);
        }
        this.method_52738((class_8021)this.buttonGrid, class_7847::method_46467);
    }

    @Override
    protected void render(class_332 graphics, int mouseX, int mouseY) {
        int startX = this.buttonGrid.method_46426() - 6 + 1;
        int startY = this.buttonGrid.method_46427() - 3;
        int width = startX + this.buttonGrid.method_25368() + 12 - 5;
        int height = startY + this.buttonGrid.method_25364() + 6 - 3;
        int color = RGB.toArgb(0x404040, 1.0f);
        graphics.method_25292(startX, width, startY, color);
        graphics.method_25292(startX, width, height, color);
        graphics.method_25301(startX, startY, height, color);
        graphics.method_25301(width, startY, height, color);
    }
}

