/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.MultiSelectableScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.config.StringField;
import net.minecraft.class_1043;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class MobsAndPlayersColorEditor
extends JmUI {
    private final String labelSelectAll = Constants.getString("jm.colorpalette.select_all");
    private final String labelSelectSameColor = Constants.getString("jm.colorpalette.select_same_color");
    private final String labelSave = Constants.getString("jm.waypoint.save");
    private final class_2561 labelClose = class_2561.method_43471((String)"jm.common.close");
    class_8667 buttonHeaderLayout;
    private Button buttonSave;
    private Button buttonSelectAll;
    private Button buttonSelectSameColor;
    int buttonHeaderHeight = 15;
    private MultiSelectableScrollListPane<DotLabelColorItem> dotLabelScrollPane;

    public MobsAndPlayersColorEditor(class_437 returnDisplay) {
        super(Constants.getString("jm.colorpalette.edit_title"), true, returnDisplay);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        class_8667 content = class_8667.method_52741();
        this.contentLayout.method_46441((class_8021)content);
        this.buttonHeaderLayout = class_8667.method_52742();
        this.buttonHeaderLayout.method_52735(2);
        content.method_52738((class_8021)this.buttonHeaderLayout, class_7847::method_46467);
        this.buttonHeaderLayout.method_52736((class_8021)class_7852.method_46513((int)this.buttonHeaderHeight));
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        class_2960 dotTexture = TextureCache.MobDotArrow;
        ArrayList<DotLabelColorItem> dotLabelItemList = new ArrayList<DotLabelColorItem>();
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.self_arrow", coreProperties.colorSelf, TextureCache.PlayerArrowBG, TextureCache.PlayerArrow, this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.passive_dot", coreProperties.colorPassive, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.passive_label", coreProperties.colorPassiveLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.hostile_dot", coreProperties.colorHostile, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.hostile_label", coreProperties.colorHostileLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.pet_dot", coreProperties.colorPet, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.pet_label", coreProperties.colorPetLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.villager_dot", coreProperties.colorVillager, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.villager_label", coreProperties.colorVillagerLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.player_dot", coreProperties.colorPlayer, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.field_22793, "jm.colorpalette.player_label", coreProperties.colorPlayerLabel, "jm.colorpalette.example_label", this));
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.dotLabelScrollPane = (MultiSelectableScrollListPane)content.method_52736(new MultiSelectableScrollListPane(this.field_22787, 0, 36 + this.buttonHeaderHeight, this.field_22789, this.field_22790 - 36 - 30 - this.buttonHeaderHeight, 30));
        this.dotLabelScrollPane.setSlots(dotLabelItemList);
        this.buttonSelectAll = (Button)this.buttonHeaderLayout.method_52738((class_8021)new Button(this.labelSelectAll, b -> this.dotLabelScrollPane.selectAll()), class_7847::method_46474);
        this.buttonSelectAll.method_53533(this.buttonHeaderHeight);
        this.buttonSelectAll.setTextOnly(this.getFontRenderer());
        this.buttonSelectAll.drawUnderline(true);
        this.buttonSelectAll.setEnabled(this.dotLabelScrollPane.getRootSlots().size() > 1);
        this.buttonSelectSameColor = (Button)this.buttonHeaderLayout.method_52738((class_8021)new Button(this.labelSelectSameColor, b -> {
            DotLabelColorItem selected = (DotLabelColorItem)this.dotLabelScrollPane.method_25334();
            if (selected != null) {
                for (DotLabelColorItem item : this.dotLabelScrollPane.getRootSlots()) {
                    if (item.color != selected.color) continue;
                    this.dotLabelScrollPane.setSelectedAndKeepCurrent(item);
                }
            }
        }), class_7847::method_46474);
        this.buttonSelectSameColor.method_53533(this.buttonHeaderHeight);
        this.buttonSelectSameColor.setTextOnly(this.getFontRenderer());
        this.buttonSelectSameColor.drawUnderline(true);
        this.buttonSelectSameColor.setEnabled(this.dotLabelScrollPane.getRootSlots().size() > 1);
        this.buttonSave = (Button)this.footerLayout.method_52736((class_8021)new Button(this.labelSave, b -> this.save()));
        this.buttonSave.method_25358(this.field_22793.method_1727(this.labelSave) + 10);
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelClose, b -> this.closeAndReturn()).method_46432(this.field_22793.method_27525((class_5348)this.labelClose) + 10).method_46431());
        this.validate();
    }

    @Override
    protected void method_48640() {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.dotLabelScrollPane.updateSize(this.field_22789, this.field_22790 - 36 - 30 - this.buttonHeaderHeight, 0, 36 + this.buttonHeaderHeight);
        this.dotLabelScrollPane.setListWidth(this.panelWidth());
        this.dotLabelScrollPane.method_44382(this.dotLabelScrollPane.method_44387());
        super.method_48640();
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        try {
            this.buttonSelectSameColor.setEnabled(this.dotLabelScrollPane.getRootSlots().size() > 1 && this.dotLabelScrollPane.getSelectedCount() == 1);
            super.method_25394(graphics, x, y, partialTicks);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.outline(graphics, 0, 36, this.field_22789 - 1, this.field_22790 - 66);
            Objects.requireNonNull(this);
            DrawUtil.drawRectangle(graphics, 0.0, 36 + this.buttonHeaderHeight, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during MobsAndPlayersColorEditor render: {}", (Object)LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    private int panelWidth() {
        return Math.min(this.field_22789, 480);
    }

    protected boolean validate() {
        boolean valid = false;
        for (DotLabelColorItem dotLabel : this.dotLabelScrollPane.getRootSlots()) {
            if (!dotLabel.isEdited()) continue;
            valid = true;
            break;
        }
        this.buttonSave.setEnabled(valid);
        return valid;
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        for (DotLabelColorItem dotLabel : this.dotLabelScrollPane.getRootSlots()) {
            if (!dotLabel.isEdited()) continue;
            dotLabel.property.set(RGB.toHexString(dotLabel.color));
            dotLabel.property.save();
        }
        JourneymapClient.getInstance().getCoreProperties().clearMobColors();
        this.refreshAndClose();
    }

    private void buttonColorPickerPressed(DotLabelColorItem item) {
        if (!this.dotLabelScrollPane.isSelectedItem(item)) {
            this.dotLabelScrollPane.setSelected(item);
        }
    }

    private void selectOnly(DotLabelColorItem item) {
        this.dotLabelScrollPane.setSelected(null);
        this.dotLabelScrollPane.setSelected(item);
    }

    private void editColorsOfSelected(int color) {
        for (Slot slot : this.dotLabelScrollPane.getAllSelected()) {
            DotLabelColorItem dotLabel = (DotLabelColorItem)slot;
            dotLabel.setColor(color);
        }
        this.validate();
    }

    protected void refreshAndClose() {
        Fullscreen.state().requireRefresh();
        this.closeAndReturn();
    }

    static class DotLabelColorItem
    extends Slot {
        private final class_327 fontRenderer;
        private final String name;
        private final StringField property;
        private class_1043 textureBG = null;
        private class_1043 texture = null;
        private String label = null;
        private int color;
        private final int originalColor;
        private final MobsAndPlayersColorEditor editor;
        private final Button buttonDefault;
        private final Button buttonUndo;
        private final ColorPickerButton buttonColorPicker;
        private final List<class_364> children = new ArrayList<class_364>();
        private long lastClick = 0L;

        DotLabelColorItem(class_327 fontRenderer, String nameKey, StringField property, String label, MobsAndPlayersColorEditor editor) {
            this(fontRenderer, nameKey, property, null, null, label, editor);
        }

        DotLabelColorItem(class_327 fontRenderer, String nameKey, StringField property, @Nullable class_2960 textureBG, class_2960 texture, MobsAndPlayersColorEditor editor) {
            this(fontRenderer, nameKey, property, textureBG, texture, null, editor);
        }

        DotLabelColorItem(class_327 fontRenderer, String nameKey, StringField property, @Nullable class_2960 textureBG, @Nullable class_2960 texture, @Nullable String labelKey, MobsAndPlayersColorEditor editor) {
            this.fontRenderer = fontRenderer;
            this.name = Constants.getString(nameKey);
            this.property = property;
            if (textureBG != null) {
                this.textureBG = TextureCache.getTexture(textureBG);
            }
            if (texture != null) {
                this.texture = TextureCache.getTexture(texture);
            }
            if (labelKey != null) {
                this.label = Constants.getString(labelKey);
            }
            this.color = this.originalColor = JourneymapClient.getInstance().getCoreProperties().getColor(property);
            this.editor = editor;
            this.buttonDefault = new Button(Constants.getString("jm.colorpalette.default"), b -> this.resetColorToDefault());
            this.buttonDefault.fitWidth(fontRenderer);
            this.buttonUndo = new Button(Constants.getString("jm.colorpalette.undo"), b -> this.undoColor());
            this.buttonUndo.fitWidth(fontRenderer);
            this.buttonColorPicker = new ColorPickerButton(24, 24, () -> this.color, () -> false, this::colorPicked);
            this.children.add((class_364)this.buttonColorPicker);
            this.children.add((class_364)this.buttonUndo);
            this.children.add((class_364)this.buttonDefault);
        }

        private void colorPicked(ColorPickerScreen.ColorPickerResponse response) {
            if (response.canceled()) {
                return;
            }
            this.editor.editColorsOfSelected(response.color());
        }

        public void setColor(int color) {
            this.color = color;
        }

        private void resetColorToDefault() {
            this.color = RGB.hexToInt(this.property.getDefaultValue());
            this.editor.validate();
        }

        private void undoColor() {
            this.color = this.originalColor;
            this.editor.validate();
        }

        public boolean isEdited() {
            return this.color != this.originalColor;
        }

        @Override
        public Collection<SlotMetadata> getMetadata() {
            return null;
        }

        public boolean method_25402(double mouseX, double mouseY, int mouseEvent) {
            try {
                if (this.buttonColorPicker.method_25402(mouseX, mouseY, mouseEvent)) {
                    this.editor.buttonColorPickerPressed(this);
                    return false;
                }
                if (this.buttonDefault.method_25402(mouseX, mouseY, mouseEvent)) {
                    return true;
                }
                if (this.buttonUndo.method_25402(mouseX, mouseY, mouseEvent)) {
                    return true;
                }
                if (mouseEvent == 0) {
                    long sysTime = class_156.method_658();
                    boolean doubleClick = sysTime - this.lastClick < 200L;
                    this.lastClick = sysTime;
                    if (doubleClick) {
                        this.buttonColorPicker.method_25306();
                        this.editor.selectOnly(this);
                        return false;
                    }
                }
                this.editor.method_48263(class_8016.method_48192((class_4069)this, (class_8016)class_8016.method_48193((class_364)this.buttonColorPicker)));
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("WARNING: Problem with mouseClicked.");
                throw new RuntimeException("mouseClicked", e);
            }
        }

        @Override
        public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
            return null;
        }

        @Override
        public SlotMetadata getLastPressed() {
            return null;
        }

        @Override
        public SlotMetadata getCurrentTooltip() {
            return null;
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public int getColumnWidth() {
            return 0;
        }

        @Override
        public boolean contains(SlotMetadata slotMetadata) {
            return false;
        }

        public void method_25343(class_332 graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            graphics.method_25294(x, y, x + rowWidth - 4, y + itemHeight, -13619152);
            int xName = 80;
            if (this.label != null) {
                int xLabel = x + xName / 2;
                int yLabel = y + itemHeight / 2;
                DrawUtil.drawLabel(graphics, this.label, xLabel, yLabel, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 1.0f, this.color, 1.0f, 1.0, false);
            } else {
                float scale = 0.2f;
                double xTex = (float)x + ((float)xName - (float)((TextureAccess)this.texture).journeymap$getWidth() * scale) / 2.0f;
                double yTex = (float)y + ((float)itemHeight - (float)((TextureAccess)this.texture).journeymap$getHeight() * scale) / 2.0f;
                graphics.method_51452();
                if (this.textureBG != null) {
                    DrawUtil.drawColoredTexture(graphics, this.textureBG, 0xFFFFFF, 1.0f, xTex, yTex, scale, 225.0);
                }
                DrawUtil.drawColoredTexture(graphics, this.texture, this.color, 1.0f, xTex, yTex, scale, 225.0);
            }
            Objects.requireNonNull(this.fontRenderer);
            graphics.method_51433(this.fontRenderer, this.name, x + xName, y + (itemHeight - 9) / 2, -1, true);
            this.buttonDefault.leftOf(x + rowWidth - 32);
            this.buttonDefault.below(y + 3);
            this.buttonDefault.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.buttonUndo.setVisible(this.isEdited());
            this.buttonUndo.leftOf(x + rowWidth - 34 - this.buttonDefault.method_25368());
            this.buttonUndo.below(y + 3);
            this.buttonUndo.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (isMouseOver || this.method_25370()) {
                this.buttonColorPicker.leftOf(x + rowWidth - 5);
                this.buttonColorPicker.below(y + 1);
                this.buttonColorPicker.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }
}

