/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import com.google.common.base.MoreObjects;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.ImageHolder;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.model.region.RegionImageCache;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.RegionTexture;
import journeymap.client.texture.TextureCache;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class RegionTile
implements RegionTexture.Listener<RegionTexture> {
    public static final int TILE_SIZE = 512;
    private static int queueCount = 0;
    private static final int MAX_TILE_QUEUE = 10;
    private final MapState state;
    private RegionTexture texture;
    private final RegionCoord regionCoord;
    private boolean textureQueued = false;
    private boolean shouldRender = false;
    private volatile Future<RegionTexture> regionFuture;
    private int x;
    private int y;
    private int zoom = 512;
    private boolean textureReady = false;

    RegionTile(RegionCoord regionCoord, MapState state) {
        this.state = state;
        this.regionCoord = regionCoord;
    }

    public static String toCacheKey(RegionCoord regionCoord, MapType mapType) {
        return regionCoord.cacheKey() + mapType.toCacheKey();
    }

    public void render(class_332 graphics, class_4597 buffers, double pixelOffsetX, double pixelOffsetZ, float alpha) {
        if (this.shouldRender && this.texture != null && this.textureReady) {
            ImageHolder holder;
            if (!this.updateRegionTexture() && (holder = this.getRegionTextureHolder(true)) != null) {
                this.texture = holder.getTexture();
            }
            if (this.texture != null && this.texture.isBound() && !this.texture.isDefunct() && this.texture.hasImage()) {
                double x = (double)this.x + pixelOffsetX;
                double y = (double)this.y + pixelOffsetZ;
                class_1921 renderType = JMRenderTypes.getRegionTile(this.texture, this.state.getMapType().getShader());
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawQuad(graphics, vertexBuilder, 0xFFFFFF, alpha, x, y, (double)this.zoom, (double)this.zoom, 0.0, false);
            }
        } else if (this.shouldRender && !this.textureQueued && queueCount < 10) {
            this.textureQueued = true;
            ++queueCount;
            CompletableFuture.supplyAsync(() -> this.getRegionTextureHolder(false).getTexture(), (Executor)class_156.method_18349()).whenComplete((tex, throwable) -> {
                this.texture = tex;
                this.textureReady = true;
                --queueCount;
            });
        }
    }

    public void setPosition(RegionCoord centerRegion, Point2D.Double centerPixel, Rectangle2D.Double regionBounds, double offsetX, double offsetZ, int zoom) {
        this.zoom = zoom;
        if (regionBounds.contains(this.regionCoord.regionX, this.regionCoord.regionZ)) {
            this.shouldRender = true;
            if (centerRegion.regionX == this.regionCoord.regionX && centerRegion.regionZ == this.regionCoord.regionZ) {
                this.x = (int)centerPixel.getX();
                this.y = (int)centerPixel.getY();
            } else {
                int diffX = this.regionCoord.regionX - centerRegion.regionX;
                int diffZ = this.regionCoord.regionZ - centerRegion.regionZ;
                this.x = (int)centerPixel.getX() + zoom * diffX;
                this.y = (int)centerPixel.getY() + zoom * diffZ;
            }
            this.x = (int)((double)this.x + offsetX);
            this.y = (int)((double)this.y + offsetZ);
        } else {
            this.shouldRender = false;
            this.textureQueued = false;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public RegionTexture getTexture() {
        return this.texture;
    }

    public RegionCoord getRegionCoord() {
        return this.regionCoord;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    private boolean updateRegionTexture() {
        ImageHolder imageHolder;
        if (this.regionFuture != null) {
            if (!this.regionFuture.isDone()) {
                return true;
            }
            this.regionFuture = null;
        }
        if ((imageHolder = this.getRegionTextureHolder(true)) != null && imageHolder.hasTexture()) {
            RegionTexture tex = imageHolder.getTexture();
            tex.addListener(this);
            if (tex.bindNeeded()) {
                tex.bind();
            }
            return false;
        }
        this.regionFuture = TextureCache.scheduleTextureTask(() -> {
            RegionTexture tex = this.getRegionTextureHolder(false).getTexture();
            tex.addListener(this);
            return tex;
        });
        return true;
    }

    ImageHolder getRegionTextureHolder(boolean async) {
        if (async) {
            return RegionImageCache.INSTANCE.getRegionImageSet(this.regionCoord).getHolderAsyncLoad(this.state.getMapType());
        }
        return RegionImageCache.INSTANCE.getRegionImageSet(this.regionCoord).getHolder(this.state.getMapType());
    }

    public int hashCode() {
        return RegionTile.toCacheKey(this.regionCoord, this.state.getMapType()).hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rc", (Object)this.regionCoord).add("type", (Object)this.state.getMapType()).add("zoom", this.zoom).add("x", this.x).add("y", this.y).toString();
    }

    @Override
    public void textureImageUpdated(RegionTexture texture) {
        if (!texture.isDefunct()) {
            this.texture = texture;
        }
    }

    public void close() {
        if (this.regionFuture != null && !this.regionFuture.isDone()) {
            this.regionFuture.cancel(true);
        }
        this.regionFuture = null;
    }
}

